/**
 * @param {Number} [ctx.itemsPerPage] количество элементов файлов на 1 странице
 * @param {String} ctx.title заголовок галлереи
 * @param {Array} ctx.galleryItems массив файлов для загрузки
 * @param {String} ctx.galleryItems.name имя файла
 * @param {String} ctx.galleryItems.url ссылка на файл
 * @param {Number} ctx.galleryItems.width ширина изображения
 * @param {Number} ctx.galleryItems.height высота изображения
 **/
block('b-gallery-file-chooser')(
    js()(function() {

        return {
            galleryItems: this.ctx.galleryItems,
            itemsPerPage: this.ctx.itemsPerPage
        };
    }),

    content()(function() {

        return [
            this.ctx.title && {
                elem: 'title',
                content: this.ctx.title
            },
            {
                elem: 'list'
            },
            {
                elem: 'pagination'
            }
        ];
    }),

    elem('pagination').content()([
        {
            block: 'button',
            mix: [{
                block: 'b-gallery-file-chooser',
                elem: 'pagination-button',
                elemMods: { type: 'gallery-back' }
            }],
            content: '←'
        },
        {
            elem: 'pagination-text'
        },
        {
            block: 'button',
            mix: [
                {
                    block: 'b-gallery-file-chooser',
                    elem: 'pagination-button',
                    elemMods: { type: 'gallery-fwd' }
                }
            ],
            content: '→'
        }
    ]),

    elem('page').content()(function() {
        return this.ctx.items.map(function(item) {
            return {
                elem: 'list-item',
                attrs: {
                    'data-id': item.id
                },
                item: item
            }
        })
    })
);
