BEM.DOM.decl({ block: 'b-grids-feedback' }, {
    onSetMod: {
        js: function() {
            this._renderFeedbackTooltip();
        }
    },
    /**
     * Рэндерит компонент обратной связи о новом интефейсе
     */
    _renderFeedbackTooltip: function() {
        var dna = window.dna,
            dnaLocalStorageInfo = u.store.get('dna');

        if (!dna) {
            return;
        }

        if (dnaLocalStorageInfo && dnaLocalStorageInfo.askWhyUserReturnedToOldInterface) {
            dna.reactDOMRender(
                dna.reactCreateElement(dna.components.FeedbackTooltip, {
                    showPromo: false,
                    askAboutReturn: true,
                    isOpenedOnRender: true,
                    showRate: false,
                    onSaveClick: this._sendFeedback
                }, null),
                this.domElem[0]
            );

            u.store.set(
                'dna',
                Object.assign(dnaLocalStorageInfo, {
                    askWhyUserReturnedToOldInterface: false
                })
            );
        }
    },
    /**
     * Делает запрос для отсылки отзыва пользователя о новом интефейсе
     */
    _sendFeedback: function(value) {
        BEM.blocks['i-web-api-request'].grid.sendFeedback(value, document.location.href);
    }
});
