BEM.DOM.decl('b-group-add-phrases', {
    onSetMod: {
        js: function() {
            BEM.blocks['i-utils'].graspSelf.call(this, {
                input: 'b-phrases-input inside',
                showBtn: 'button inside suggestions-toggler'
            });

            this.model = BEM.MODEL.getOne(this.params.modelParams);

            (this.getMod('suggestions') == 'on') && this.initSuggestionsBlock();

            this.showBtn.on('click', function() {
                this.setMod('suggestions', 'on');
                !this.suggestions && this.initSuggestionsBlock();
            }, this);

            BEM.MODEL.on({ name: 'm-phrase-text', parentModel: this.model }, 'create', function() {
                this.setMod('has-splited', 'yes');
            }, this);
        }
    },

    initSuggestionsBlock: function() {
        this.suggestions = this.findBlockInside('b-phrases-suggestions');

        if (!this.suggestions) {
            BEM.DOM.after(this.elem('input'), BEMHTML.apply({
                block: 'b-phrases-suggestions',
                modelParams: this.params.modelParams
            }));
            this.suggestions = this.findBlockInside('b-phrases-suggestions');
        }

        this.suggestions.on('hide', function() {
            this.setMod('suggestions', 'off');
        }, this);

        return this;
    }

}, {

    live: function() {

        this.liveInitOnBlockInsideEvent('init', 'b-phrases-input')
            .liveInitOnBlockInsideEvent('change', 'b-phrases-input', function() {
                this.trigger('suggestions-change');
            })
            .liveInitOnBlockInsideEvent('change', 'b-group-edit-phrases-block', function() {
                this.trigger('phrases-block-change');
            });

    }

});
