block('b-group-dynamic-condition')(

    def()(function() {
        var condition = this.ctx.condition;

        condition.state = this.ctx.state;

        return applyNext();
    }),

    js()(function() {
        return !this.data.view_only && !(this.data.archived == 'Yes') ?
            {
                modelParams: {
                    name: 'b-group-dynamic-condition',
                    id: this.ctx.condition.dyn_id
                },
                conditionId: this.ctx.condition.dyn_id,
                adgroupId: this.ctx.condition.adgroup_id,
                colsNum: this.ctx.colsNum
            } :
            false;
    }),

    content()(function() {
        var condition = this.ctx.condition,
            data = this.data,
            campaignIsArchived = data.archived === 'Yes',
            canEditText = !data.campaign.readonly && !this.ctx.readonly && !campaignIsArchived,
            isAutobudgetStrategy = this.data.campaign.autobudget == 'Yes',
            res = [
                {
                    block: 'b-group-dynamic-condition',
                    elem: 'cell',
                    elemMods: {
                        first: 'yes'
                    },
                    mix: [{
                        block: 'b-style-table',
                        elem: 'cell',
                        elemMods: {
                            first: 'yes'
                        }
                    }],
                    content: {
                        block: 'b-dynamic-condition-row',
                        mods: {
                            editable: canEditText ? 'yes' : 'no',
                            clickable: !campaignIsArchived ? 'yes' : 'no'
                        },
                        mix: [{
                            block: 'b-group-dynamic-condition',
                            elem: 'row'
                        }],
                        condition: condition,
                        currency: this.ctx.group.currency
                    }
                }
            ];

        if (campaignIsArchived) {
            res.push({
                block: 'b-group-dynamic-condition',
                elem: 'cell',
                mix: [{
                    block: 'b-style-table',
                    elem: 'cell',
                    elemMods: {
                        align: 'right'
                    }
                }],
                content: this.ctx.isFirst ?
                    iget2(
                        'b-group-dynamic-condition',
                        'statistika-po-arhivnym-kampaniyam',
                        'Статистика по архивным кампаниям доступна в {link}',
                        {
                            link: function(text) {
                                return {
                                    block: 'link',
                                    url: u.getUrl('showStat', {
                                        stat_type: 'moc',
                                        single_camp: 1,
                                        with_auto_added_phrases: 1,
                                        isStat: 1,
                                        cid: data.campaign.cid,
                                        ulogin: u.consts('ulogin')
                                    }),
                                    content: text
                                };
                            }(iget2('b-group-dynamic-condition', 'statistika-po-arhivnym-kampaniyam-param-link', 'Мастере отчетов')),

                            context: 'link - Мастере отчетов'
                        }
                    ) : ''
            });
        } else if (this.ctx.group.is_bs_rarely_loaded == 1) {
            res.push({
                block: 'b-group-dynamic-condition',
                elem: 'cell',
                // зависит от ячеек в хедере
                attrs: {
                    colspan: this.ctx.platform == 'context' ? 1 : 3
                },
                mix: [{
                    block: 'b-style-table',
                    elem: 'cell',
                    elemMods: {
                        align: 'right'
                    }
                }],
                content: {
                    block: 'b-rarely-served-message',
                    adgroupType: this.ctx.group.adgroup_type
                }
            });
        } else if (this.data.showStat && this.ctx.platform == 'context') {
            res.push({
                block: 'b-group-dynamic-condition',
                elem: 'cell',
                mix: [{
                    block: 'b-style-table',
                    elem: 'cell',
                    elemMods: {
                        align: 'center'
                    }
                }],
                content: {
                    elem: 'ctx-clicks',
                    content: condition.ctx_clicks || '0'
                }
            });
        } else if (this.data.showStat) {
            ['shows', 'clicks', 'ctr'].map(function(name) {
                res.push({
                    block: 'b-group-dynamic-condition',
                    elem: 'cell',
                    mix: [{
                        block: 'b-style-table',
                        elem: 'cell',
                        elemMods: {
                            align: 'center'
                        }
                    }],
                    content: {
                        elem: name,
                        content: condition[name]
                    }
                });
            });
        }

        res.push({
            block: 'b-group-dynamic-condition',
            elem: 'cell',
            mix: [{
                block: 'b-style-table',
                elem: 'cell',
                elemMods: {
                    align: 'center'
                }
            }],
            content: (this.ctx.isConditionIsOfTypeAny && isAutobudgetStrategy) ?
                '' :
                {
                    block: 'b-group-dynamic-condition',
                    elem: 'price',
                    platform: this.ctx.platform,
                    condition: condition,
                    group: this.ctx.group
                }
        });

        return res;
    })
);

block('b-group-dynamic-condition').elem('price').content()(function() {
    var controlType,
        condition = this.ctx.condition,
        platform = this.ctx.platform,
        campaignIsArchived = this.data.archived == 'Yes';

    if (platform == 'search') {
        controlType = 'search';
    } else if (platform == 'context' && this.data.campaign.autobudget == 'No') {
        controlType = 'context';
    } else if (this.data.campaign.autobudget == 'Yes') {
        controlType = 'autobudget';
    } else if (condition.search_editable_price) {
        controlType = 'search';
    } else if (condition.context_editable_price) {
        controlType = 'context';
    } else if (condition.rank > this.data.MIN_PHRASE_RANK_WARNING && condition.declined) {
        controlType = 'search';
    } else if (!condition.context_stop_flag && condition.declined) {
        controlType = 'context';
    } else {
        controlType = 'low-ctr';
    }

    if (controlType === 'autobudget') {
        return '';
    }

    var price = controlType === 'search' ? condition.price : condition.price_context;

    return !!this.data.view_only || !this.ctx.group.editable_price ?
        {
            elem: 'price-wrapper',
            content: price
        } :
        {
            block: 'b-edit-phrase-price',
            campDMParams: {
                id: this.data.campaign.cid,
                name: u.campaign.getCampaignModelName(this.data.campaign.mediaType)
            },
            price: price,
            condition: this.ctx.condition,
            group: this.ctx.group,
            platform: this.ctx.platform,
            name: (controlType === 'search' ? 'val' : 'ctx_val'),
            hasError: this.ctx.condition.errors[controlType === 'search' ? 'price' : 'price_context'],
            hasWarning: this.ctx.condition.warnings[controlType === 'search' ? 'price' : 'price_context'],
            mods: {
                'control-type': controlType
            }
        };
});
