(function() {
    BEM.DOM.decl({ block: 'b-group-dynamic-condition', baseBlock: 'i-glue' }, {
        onSetMod: {
            js: function() {
                this.__base.apply(this, arguments);

                this.modelParams = this.params.modelParams;

                //alkaline@todo i-model-aggregator создает модели только при вызове getOrCreate
                //alkaline@todo чтобы обратиться к вложенной модели приходится сначала создавать родителькую
                BEM.MODEL.getOrCreate({ name: 'dm-dynamic-group', id: +this.params.adgroupId });
                this.dmDynamicCondition = BEM.MODEL.getOrCreate({
                    name: 'dm-dynamic-condition',
                    id: +this.params.conditionId
                });

                this.dmDynamicCondition.on('change', function(e, data) {
                    this.model.update(this._prepareDataFromDM(this.dmDynamicCondition.toJSON()));
                }, this);

                this.model.update(this._prepareDataFromDM(this.dmDynamicCondition.toJSON())).fix();

                this.model.on('price price_context', 'change', function(e, data) {
                    this.dmDynamicCondition.update({
                        price: this.model.get('price'),
                        price_context: this.model.get('price_context')
                    });
                }, this);

                this.bindEvents();
                this.priceControls = {};
                this.initControls();
            }
        },

        /**
         * Достает из переданных данных только поля задекларированные в vm и преобразовывает их
         *
         * @param {Object} dmDynamicConditionData
         * @returns {Object}
         * @private
         */
        _prepareDataFromDM: function(dmDynamicConditionData) {
            dmDynamicConditionData = u._.pick(dmDynamicConditionData, Object.keys(this.model.fieldsDecl));

            dmDynamicConditionData.condition.forEach(function(goal) {
                goal.value = u['b-dynamic-goal-edit-value'].makeValueArray(goal);
            });
            return dmDynamicConditionData;
        },

        /**
         * Возвращаем модель b-group-dynamic-condition соответствующую данному блоку
         * @returns {BEM.MODEL}
         */
        getModel: function() {
            return this.dmDynamicCondition;
        },

        /**
         * Инициализируем контролы
         * @returns {BEM}
         */
        initControls: function() {
            var priceControls = this.findBlocksInside('b-edit-phrase-price');

            priceControls && priceControls.forEach(function(control) {
                control.initModels([this.model]);
                this.priceControls[control.getMod('control-type')] = control;
            }, this);

            this.findBlocksInside('b-dynamic-condition-row');

            return this;
        },

        /**
         * Привязываем колбэки к событиям модели
         * @returns {BEM}
         */
        bindEvents: function() {
            this.model
                .on('is_deleted', 'change', this.onConditionDelete, this)
                .on('is_suspended', 'change', function(e, data) {
                    this.setMod('is-suspended', this.model.get('is_suspended') ? 'yes' : '');
                }, this);

            this.model.getDM().onFirst('destruct', this.onConditionDeleteComplete, this);

            return this;
        },

        /**
         * Формирует элемент для восстановления удаленной фразы
         * Подписывается на click по кнопке восстановления
         */
        formRestoreRow: function() {
            this.elem('cell', 'first', 'yes').append($(BEMHTML.apply({
                block: 'b-group-dynamic-condition',
                elem: 'restore-row',
                mods: { type: this.getMod('type') },
                text: iget2('b-group-dynamic-condition', 'uslovie-nacelivaniya-s-bylo', 'Условие нацеливания "{foo}" было удалено', {
                    foo: this.model.get('condition_name')
                })
            })));

            this.findBlockOn('restore', 'button').on('click', function() {
                this.model.set('is_deleted', false);
                this.dmDynamicCondition.set('is_deleted', false);
            }, this);
        },

        /**
         * Обработчик изменения значения флага deleted у модели
         * @returns {BEM}
         */
        onConditionDelete: function(e, data) {
            var isDeleted = this.model.get('is_deleted');

            !this.findElem('restore-row').length && this.formRestoreRow();

            this.toggleMod('deleted', 'yes', isDeleted);

            return this;
        },

        onConditionDeleteComplete: function() {
            //инициализируем группу к которой принадлежит фраза - возможно придется скрывать заголовок
            this.findBlockOutside('b-dynamic-conditions-table');
            this.destruct();
        }
    });

})();
