/**
 * @param {Object} modelParams параметры модели кампании для данного блока
 * @param {String} modelParams.name
 * @param {String} modelParams.id
 */
block('b-group-edit-phrase')(
    js()(function() {
        return {
            modelParams: this.ctx.modelParams,
            type: this.mods.type
        };
    }),

    mix()([
        {
            block: 'b-layout-table',
            elem: 'row'
        }
    ]),

    tag()('tr'),

    content()(function() {
        var maxLength = 4096,
            phrase = this.ctx.phrase,
            text = phrase.key_words +
                (phrase.minus_words.length ? ' ' + u.minusWords.arrayToString(phrase.minus_words) : '');

        return [
            {
                block: 'b-layout-table',
                elem: 'cell',
                mix: {
                    block: 'b-group-edit-phrase',
                    elem: 'remove-cell'
                },
                content: {
                    block: 'link',
                    mix: {
                        block: 'b-group-edit-phrase',
                        elem: 'remove'
                    },
                    mods: {
                        pseudo: 'yes',
                        style: 'without-border'
                    },
                    content: {
                        block: 'b-icon',
                        mods: {
                            'size-13': 'grey-cross'
                        }
                    }
                }
            },
            {
                block: 'b-layout-table',
                elem: 'cell',
                elemMods: {
                    type: 'content'
                },
                mix: [{
                    block: 'b-group-edit-phrase',
                    elem: 'input-cell'
                }],
                content: {
                    block: 'input',
                    mix: [{
                        block: 'b-group-edit-phrase',
                        elem: 'input'
                    }],
                    value: text,
                    content: [
                        {
                            elem: 'control'
                        },
                        {
                            elem: 'numerator',
                            value: maxLength,
                            elemMods: {
                                exceed: text.length > maxLength ? 'yes' : ''
                            }
                        }
                    ]
                }
            },
            {
                block: 'b-layout-table',
                elem: 'cell',
                mix: [{
                    block: 'b-group-edit-phrase',
                    elem: 'adjust-cell'
                }],
                content: {
                    block: 'button',
                    type: 'button',
                    mix: [{
                        block: 'b-group-edit-phrase',
                        elem: 'adjust'
                    }],
                    mods: {
                        theme: 'normal',
                        pseudo: 'yes'
                    },
                    content: iget2('b-group-edit-phrase', 'utochnit', 'уточнить')
                }
            }
        ];
    })
);
