BEM.DOM.decl({ block: 'b-group-edit-phrase' }, {
    onSetMod: {
        js: function() {
            this.phraseModel = BEM.MODEL.getOrCreate(this.params.modelParams);
            this.groupModel = this.phraseModel.getParentModel();

            BEM.blocks['i-utils'].graspSelf.call(this, {
                remove: 'link on remove',
                input: 'input on input',
                adjust: 'button on adjust'
            });

            // при потере фокуса обновляем поле ввода значением модели
            this.input.on('blur', function() {
                this._setInputValue(this.phraseModel.get('phrase'));
            }, this);

            this.phraseModel.on('minus_words key_words', 'change', this._onWordsChanged, this);

            this.bindGroupModel();
        }
    },

    /**
     * Удаляет ключевую фразу из группы
     * @returns {BEM}
     * @private
     */
    _removePhrase: function() {
        if (this.groupModel.isLastActive(this.phraseModel)) {
            BEM.blocks['b-confirm'].alert(iget2('b-group-edit-phrase', 'nelzya-udalit-poslednyuyu-frazu', 'Нельзя удалить последнюю фразу в группе'));

            return this;
        }

        var phraseId = this.phraseModel.get('modelId'),
            phrasesIds = this.groupModel.get('phrasesIds'),
            pos = -1;

        phrasesIds.some(function(id, i) {
            return id == phraseId && (pos = i) + 1;
        });

        pos != -1 && phrasesIds.splice(pos, 1);

        this.trigger('remove');

        this.destruct();

        return this;
    },

    destruct: function() {
        this.phraseModel.destruct();

        return this.__base.apply(this, arguments);
    },

    /**
     * Инициализация модели баннера
     */
    bindGroupModel: function() {
        // Запоминаем предыдущую версию фразы в phrase модели баннера один раз при инициализации блока
        this._previousPhrase = this.phraseModel.get('phrase');
    },

    /**
     * Предыдущая версия фразы
     * @private
     */
    _previousPhrase: null,

    /**
     * Вызывает обновление значения инпута
     * при изменении минус слов или ключевых слов
     * @returns {BEM}
     */
    _onWordsChanged: function() {
        // обновлять поле ввода, только если на нем не установлен фокус
        this.input.hasMod('focused', 'yes') || this._setInputValue(this.phraseModel.get('phrase'));

        return this;
    },

    /**
     * Выставляет значение контрола
     * @param {String} value
     * @returns {BEM.DOM}
     */
    _setInputValue: function(value) {
        this.input.val(value);

        return this;
    },

    /**
     * Обработчик события click по кнопке «уточнить»
     * @returns {BEM}
     */
    onAdjustClick: function() {
        return this.showEditPopup();
    },

    /**
     * Обработчик события на инпуте
     * дизейблит|раздизейблит кнопку «уточнить»
     * обновляет модель m-phrase-text
     * @returns {BEM}
     */
    _onInputChange: function(phrase) {
        phrase ?
            this.adjust.delMod('disabled') :
            this.adjust.setMod('disabled', 'yes');

        this.updateModel(phrase);

        return this;
    },

    /**
     * Обработчик события change из клика по крестику инпута
     * дизейблит кнопку «уточнить»
     * обновляет модель m-phrase-text
     * @param {String} phrase
     * @private
     */
    _onClearChange: function(phrase) {
        this.adjust.setMod('disabled', 'yes');

        this.updateModel(phrase);
    },

    /**
     * Обновляет в модели m-phrase-text поля minus_words, key_words
     * @param {String} value
     */
    updateModel: function(value) {
        this.phraseModel.update({
            is_deleted: u._.isEmpty(value),
            minus_words: u.phraseFormatter.getMinusWords(value),
            key_words: u.phraseFormatter.getKeyWords(value)
        }, { source: this });

        this.trigger('change');
    },

    /**
     * Открыть попап уточнения фразы
     * @returns {BEM}
     */
    showEditPopup: function() {
        this.__self.getPopup().show(this.domElem).init({
            phraseModel: this.phraseModel,
            bannersGroupModel: this.groupModel,
            parentDomElem: this.domElem
        });

        return this;
    }

}, {

    live: function() {
        this
            .liveInitOnBlockInsideEvent('click', 'button', function(e) {
                this.onAdjustClick(e);
            })
            .liveInitOnBlockInsideEvent('click', 'link', function(e) {
                this._removePhrase(e);
            })
            .liveInitOnBlockInsideEvent('change', 'input', function(e, data) {
                this[(data || {}).source === 'clear' ? '_onClearChange' : '_onInputChange']($.trim(e.block.val()));
            });
    },

    getPopup: function(params) {
        return this._popup || (this._popup = $(BEMHTML.apply({
            block: 'b-phrase-popup',
            mods: { page: 'multiedit' }
        })).appendTo(BEM.blocks['b-page'].getInstance().domElem).bem('popup').findBlockOn('b-phrase-popup'));
    }
});
