BEM.DOM.decl({ name: 'b-group-edit-phrases-block', modName: 'type', modVal: 'new' }, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);
            this.spin = this.findBlockInside('spin');

            this.onPhraseModelCreateDebounce = $.debounce(this.onPhraseModelCreate, 1000, this);

            this.created = [];

            //не использую стандартное create - так как у существующих фраз модели тоже создаются в процессе
            this.groupModel.on('create-new-model', function(e, data) {
                this.spin.setMod('progress', 'yes');
                this.created.push(data.model);
                this.onPhraseModelCreateDebounce();
            }, this);
        }
    },

    /**
     * Была создана новая модель для фразы
     * @returns {BEM}
     */
    onPhraseModelCreate: function() {
        this.spin.delMod('progress');
        BEM.DOM.append(this.elem('table'), BEMHTML.apply(this.created.map(function(model) {
            return {
                block: 'b-group-edit-phrase',
                mods: { type: 'new' },
                modelParams: {
                    name: 'm-phrase-text',
                    id: model.id,
                    parentId: this.params.adgroupId,
                    parentName: this.params.modelName
                },
                buildOnClient: true,
                phrase: {
                    key_words: model.get('key_words'),
                    minus_words: model.get('minus_words'),
                    id: model.get('id')
                }
            };
        }, this)));

        //
        //this.findBlocksInside('b-group-edit-phrase').forEach(function(block) {
        //    block.updateBannerModel();
        //});
        this.created = [];

        return this;
    }
});
