block('b-group-edit-phrases-block')(
    addJs()(function() {
        return {
            adgroupId: this.ctx.adgroupId,
            modelName: this.ctx.modelName,
            campaignModelName: this.ctx.campaignModelName
        };
    }),

    content()(function() {
        return [
            this.mods.type == 'new' && {
                block: 'spin',
                mods: {
                    theme: 'gray-16'
                }
            },
            !this.ctx.noTitle && {
                elem: 'title',
                content: this.mods.type == 'suspended' ?
                    iget2('b-group-edit-phrases-block', 'ostanovlennye', 'остановленные') : this.mods.type == 'active' ?
                    iget2('b-group-edit-phrases-block', 'aktivnye', 'активные') : this.mods.type == 'declined' ? iget2('b-group-edit-phrases-block', 'otklonennye-na-moderacii', 'отклоненные на модерации') : ''
            },
            {
                block: 'b-layout-table',
                mods: {
                    layout: 'form'
                },
                mix: [{
                    block: 'b-group-edit-phrases-block',
                    elem: 'table'
                }],
                content: [
                    {
                        block: 'i-model-aggregator',
                        content: this.ctx.phrases ?
                            this.ctx.phrases.map(function(phrase) {
                                return {
                                    block: 'i-model',
                                    modelParams: {
                                        name: 'm-phrase-text',
                                        id: phrase.modelId,
                                        parentId: this.ctx.adgroupId,
                                        parentName: this.ctx.modelName || 'm-group',
                                        data: applyCtx({
                                            block: 'm-phrase-text',
                                            phrase: phrase
                                        })
                                    }
                                };
                            }, this) : ''
                    },
                    this.ctx.phrases ?
                    this.ctx.phrases.map(function(phrase) {
                        return {
                            block: 'b-group-edit-phrase',
                            phrase: phrase,
                            mods: {
                                type: this.mods.type
                            },
                            modelParams: {
                                name: 'm-phrase-text',
                                id: phrase.modelId,
                                parentId: this.ctx.adgroupId,
                                parentName: this.ctx.modelName
                            },
                            campaignModelName: this.ctx.campaignModelName
                        };
                    }, this) :
                    ''
                ]
            }
        ];
    })
);
