BEM.DOM.decl({ block: 'b-group-edit-phrases' }, {

    onSetMod: {
        js: function() {
            this.model = BEM.MODEL.getOrCreate({ name: this.params.modelName || 'm-group', id: this.params.adgroupId });

            this.bindTo('phrases-list-btn', 'click', function(e) {
                // т. к. кнопки должны отдавать списки старых и новых фраз соответственно, пробрасываем модификатор нажатой
                this._togglePopup(e, this.getMods(this.findElem($(e.target), 'phrases-list-btn')).type);
            });

            BEM.blocks['b-group-edit-phrase']
                .on(this.domElem, 'change remove', function(e, data) {
                    if (e.type === 'remove') {
                        this.model.getPhrasesModels().length === 0 && this.destruct();
                    }

                    // для очистки ошибок b-errors-presenter2__cleaner
                    this.trigger('change');
                }, this);
        }
    },

    /**
     * Обработчик события 'click' по кнопке 'phrases-list-btn'
     * @param {Event} e
     * @param {'new'|undefined} type тип кнопки, список новых фраз, или уже существовавших
     * @private
     */
    _togglePopup: function(e, type) {
        var popup = this.__self._getPopup(this.model, type),
            owner = $(e.target);

        this.__self._currentId === this.model.get('adgroup_id') ?
            popup.toggle(owner) :
            popup.show(owner) && (this.__self._currentId = this.model.get('adgroup_id'));

    }

}, {

    /**
     * Возвращает список фраз, полученный из модели баннера
     * @param {Object} model
     * @param {'new'|undefined} type список новых, или уже существовавших фраз
     * @returns {String}
     * @private
     */
    _getContent: function(model, type) {
        var result = [];

        BEM.MODEL.get({ name: 'm-phrase-text', parentModel: model }).forEach(function(phraseModel) {
            var id = phraseModel.get('id'),
                phrase = phraseModel.get('phrase');

            if (type == 'new' ? id == 0 : id) {
                phrase && result.push(phrase); // если фраза не удалена а очищена, не пушим DIRECT-44916
            }
        });

        return u.escapeHTML(result.join(', '));
    },

    /**
     * Текущий id баннера
     */
    _currentId: null,

    /**
     * Строит попап или заменяет контент попапа
     * Заменяет контент, когда обновись фразы в модели
     * @param {Object} model
     * @param {'new'|undefined} type список новых, или уже существовавших фраз
     * @returns {BEM}
     * @private
     */
    _getPopup: function(model, type) {
        var content = this._getContent(model, type);

        if (!content) {
            content = BEMHTML.apply({
                block: 'b-group-edit-phrases',
                elem: 'empty-phrases-list',
                content: iget2('b-group-edit-phrases', 'net-fraz', 'Нет фраз')
            });
        }

        if (this.phrasesPopup) {
            this.phrasesPopup.setContent(content);
        } else {
            this._currentId = model.get('adgroup_id');
            this.phrasesPopup = $(BEMHTML.apply({
                block: 'popup',
                js: { directions: 'right' },
                mods: { 'has-close': 'yes' },
                content: [
                    { elem: 'tail' },
                    {
                        elem: 'content',
                        mix: [{ block: 'b-group-edit-phrases', elem: 'phrases-list-popup' }],
                        content: content
                    }
                ]
            })).bem('popup');

        }

        return this.phrasesPopup;
    }
});
