/**
 * @param {String} text название параметра фида, которое должны использовать при отборе
 * @param {String} errorPath
 **/
block('b-group-feed-field-for-body')(
    js()(function() {
        return true
    }),
    content()(function() {
        var title = this.ctx.title;

        return [
            {
                elem: 'switcher-container',
                content: [
                    {
                        block: 'checkbox',
                        mods: {
                            checked: title ? 'yes' : ''
                        },
                        mix: {
                            block: 'b-group-feed-field-for-body',
                            elem: 'switcher'
                        },
                        text: iget2('b-group-feed-field-for-body', 'switcher-label', 'Подставлять значение из фида вместо текста объявления')
                    },
                    {
                        block: 'b-help-link',
                        mods: {
                            type: 'modal'
                        },
                        stretched: true,
                        url: u.getHelpUrl('smart-banners-field-as-body')
                    }
                ]
            },
            {
                elem: 'name-controls',
                elemMods: {
                    hidden: title ? '' : 'yes'
                },
                content: [
                    {
                        elem: 'name-controls-label',
                        content: iget2('b-group-feed-field-for-body', 'name-controls-label', 'Использовать')
                    },
                    {
                        block: 'input',
                        mix: [{
                            block: 'b-group-feed-field-for-body',
                            elem: 'name-controls-field'
                        }],
                        value: title,
                        content: [{ elem: 'control' }]
                    }
                ]
            },
            {
                block: 'b-error-message',
                js: { path: this.ctx.errorPath }
            }
        ];
    })
);
