/**
 * Событие изменения состояния контрола
 * @event b-group-feed-field-for-body#change
 * @type {Object}
 * @property {Boolean} isChecked состояние флага 'Подставлять значение из фида в качестве текста смарт-объявления'
 * @property {String} value значение поля текста параметра фида
 */

/**
 * @fires b-group-feed#change
 */
BEM.DOM.decl('b-group-feed-field-for-body', {
    onSetMod: {
        js: function() {
            this.__base();

            u.graspSelf.call(this, {
                _switcher: 'checkbox on switcher',
                _bodyField: 'input on name-controls-field'
            });

            this._subscriptions = BEM.create('i-subscription-manager');

            this._subscriptions.on(this._switcher, 'change', this._onCheckboxChange, this);
            this._subscriptions.on(this._bodyField, 'change', this._onNameFieldChange, this);
        }
    },

    /**
     * Возвращает текущее состояние контролов
     * @returns {{isChecked: Boolean, value: String}}
     */
    getValue: function() {
        return {
            isChecked: this._switcher.isChecked(),
            value: this._bodyField.val()
        }
    },

    /**
     * Устанавливает значение контролов
     * @param {{isChecked: Boolean, value: String}} value
     */
    setValue: function(value) {
        this._switcher.setMod('checked', value.isChecked ? 'yes' : '');
        this._bodyField.val(value.value);
    },

    /**
     * Удаляет блок, модель и подписки i-subscription-manager
     * @override
     */
    destruct: function() {
        this._subscriptions.dispose();

        this.__base.apply(this, arguments);
    },

    /**
     * Обработчик события изменения поля текста параметра фида
     */
    _onNameFieldChange: function() {
        this._triggerChange();
    },

    /**
     * Обработчик события изменения состояния флага 'Подставлять текст из фида в качестве описания товара'
     * @param {Event} event
     * @param {Object} data
     * @param {Boolean} data.checked
     */
    _onCheckboxChange: function(event, data) {
        this.setMod(this.elem('name-controls'), 'hidden', data.checked ? '' : 'yes');

        if (this._bodyField.val().trim() === '') {
            this._bodyField.setMod('focused', 'yes');
            this._bodyField.elem('control').focus();
        }

        this._triggerChange();
    },

    /**
     * Триггерит событие изменения состояния контрола
     */
    _triggerChange: function() {
        this.trigger('change', this.getValue());
    }
});
