/**
 * @param {String} title название параметра фида, которое должны использовать при отборе
 * @param {String} errorPath
 **/
block('b-group-feed-field-for-name')(
    content()(function() {
        var title = this.ctx.title;

        return [
            {
                elem: 'switcher-container',
                content: [
                    {
                        block: 'checkbox',
                        mods: {
                            checked: title ? 'yes' : ''
                        },
                        mix: {
                            block: 'b-group-feed-field-for-name',
                            elem: 'switcher'
                        },
                        text: iget2('b-group-feed-field-for-name', 'switcher-label', 'Подставлять значение из фида в качестве заголовка')
                    },
                    {
                        block: 'b-help-link',
                        mods: {
                            type: 'modal'
                        },
                        stretched: true,
                        url: u.getHelpUrl('smart-banners-field-as-title')
                    }
                ]
            },
            {
                elem: 'name-controls',
                elemMods: {
                    hidden: title ? '' : 'yes'
                },
                content: [
                    {
                        elem: 'name-controls-label',
                        content: iget2('b-group-feed-field-for-name', 'name-controls-label', 'Использовать')
                    },
                    {
                        block: 'input',
                        mix: [{
                            block: 'b-group-feed-field-for-name',
                            elem: 'name-controls-field'
                        }],
                        value: title,
                        content: [{ elem: 'control' }]
                    }
                ]
            },
            {
                block: 'b-error-message',
                js: { path: this.ctx.errorPath }
            }
        ];
    })
);
