block('b-group-feed-filter').elem('cell')(

    tag()('td'),

    mode('has-warning')(function() {
        return apply('filter-price') > u.currencies.getConst(this.ctx.filter.currency, 'BIG_RATE');
    }),

    mode('has-error')(function() {
        var price = apply('filter-price'),
            currency = this.ctx.filter.currency,
            minValue = this.ctx.filter.adgroup_type !== 'dynamic' ?
                u.currencies.getConst(currency, 'MIN_CPC_CPA_PERFORMANCE') :
                u.currencies.getConst(currency, 'MIN_PRICE');

        return !isNaN(price) && !(minValue <= price && price <= u.currencies.getConst(currency, 'MAX_PRICE'));
    }),

    elemMod('edit-price', 'yes')(
        mode('filter-price')(function() { return +this.ctx.filter[this.ctx.name] || undefined }),

        mode('block-data')(function() {
            return {
                block: 'b-edit-phrase-price',
                mods: {
                    'control-type': this.ctx.controlType,
                    'auto-validation': 'yes',
                    'has-empty': this.ctx.hasEmptyField ? 'yes' : '',
                    warning: apply('has-warning') ? 'yes' : '',
                    error: apply('has-error') ? 'yes' : ''
                },
                mix: {
                    block: 'b-group-feed-filter',
                    elem: 'edit-price'
                },
                campDMParams: {
                    id: this.ctx.group.cid,
                    name: u.campaign.getCampaignModelName(this.ctx.group.adgroup_type)
                }
            }
        }),

        content()(function() {
            if (this.ctx.name === 'autobudgetPriority') {
                return '';
            }

            return u.numberFormatter.format(apply('filter-price')) || '&mdash;';
        }),

        elemMod('editable', 'yes').content()(function() {
            if (this.ctx.name === 'autobudgetPriority') {
                return ''
            }

            var blockData = apply('block-data');
            blockData.price = u.numberFormatter.format(apply('filter-price')) || '';

            return blockData;
        })
    ),

    // переключатель ставки на общую
    elemMod('price-mode-toggle', 'yes').content()(function() {
        return {
            block: 'link',
            mods: { pseudo: 'yes' },
            mix: {
                block: 'b-group-feed-filter',
                elem: 'price-mode-toggle-link'
            },
            content: [
                {
                    block: 'b-group-feed-filter',
                    elem: 'reset-price-caption',
                    tag: 'span',
                    content: iget2('b-group-feed-filter', 'reset-filter-bid', 'Сбросить ставку на фильтре')
                },
                {
                    block: 'b-group-feed-filter',
                    elem: 'set-price-caption',
                    tag: 'span',
                    content: iget2('b-group-feed-filter', 'set-filter-bid', 'Назначить ставку на фильтре')
                }
            ]
        };
    }),

    // ячейки статистики
    elemMod('stat', 'shows').content()(function() {
        return u.numberFormatter.format(this.ctx.filter.ctx_shows || 0, { precision: 0 });
    }),

    elemMod('stat', 'clicks').content()(function() {
        return u.numberFormatter.format(this.ctx.filter.ctx_clicks || 0, { precision: 0 });
    }),

    elemMod('stat', 'ctr').content()(function() {
        return u.numberFormatter.format(this.ctx.filter.ctx_ctr || 0, { precision: 2 });
    }),

    elemMod('type', 'rarely-served').content()(function() {
        return {
            block: 'b-rarely-served-message',
            adgroupType: this.ctx.group.adgroup_type,
            isFilter: true
        };
    }),

    elemMod('type', 'archived-campaign-warning').content()(function() {
        var cid = this.ctx.cid;

        return iget2('b-group-feed-filter', 'statistika-po-arhivnym-kampaniyam', 'Статистика по архивным кампаниям доступна в {link}', {
            link: function(text) {
                return {
                    block: 'link',
                    url: u.getUrl('showStat', {
                        stat_type: 'moc',
                        single_camp: 1,
                        with_auto_added_phrases: 1,
                        isStat: 1,
                        cid: cid,
                        ulogin: u.consts('ulogin')
                    }),
                    content: text
                };
            }(iget2('b-group-feed-filter', 'statistika-po-arhivnym-kampaniyam-param-link', 'Мастере отчетов')),

            context: 'link - Мастере отчетов'
        });
    }),

    elemMod('type', 'gap-cell').content()('&nbsp;')
);
