block('b-group-feed-filter').elem('price')(
    mode('fields')([]),

    mode('has-empty-field')(false),

    mode('resettable')(false),

    mode('cells')(function() {
        return apply('fields',
            {
                nowOptimizingBy: this.ctx.nowOptimizingBy,
                hasDefaultPrice: this.ctx.filter.has_default_price
            }).map(function(data) {

                return {
                    elem: 'cell',
                    elemMods: {
                        'edit-price': 'yes',
                        'edit-price-type': data.controlType,
                        editable: this.ctx.filter.is_price_editable ? 'yes' : ''
                    },
                    mix: {
                        block: 'b-style-table',
                        elem: 'cell',
                        elemMods: { align: 'center' }
                    },
                    name: data.name,
                    hasEmptyField: data.hasEmptyField,
                    controlType: data.controlType,
                    group: this.ctx.group,
                    highlight: data.highlight,
                    filter: this.ctx.filter
                };
            }, this);
    }),

    // по умолчанию выбор приоритета
    elemMod('strategy', 'default').mode('fields')([{
        name: 'autobudgetPriority',
        controlType: 'autobudget'
    }]),

    // стратегия оптимизация количества конверсий
    elemMod('strategy', 'avg-cpa')(
        mode('resettable')(true),

        mode('fields')([
            {
                name: 'price_cpa',
                highlight: this.nowOptimizingBy == 'CPA' ? 'yes' : '',
                hasEmptyField: this.hasDefaultPrice && apply('has-empty-field'),
                controlType: 'cpa'
            }
        ])
    ),

    // стратегия оптимизация количества кликов
    elemMod('strategy', 'avg-cpc')(
        mode('resettable')(true),

        mode('fields')([
            {
                name: 'price_cpc',
                highlight: this.nowOptimizingBy == 'CPC' ? 'yes' : '',
                hasEmptyField: this.hasDefaultPrice && apply('has-empty-field'),
                controlType: 'cpc'
            }
        ])
    ),

    //раздельное размещение
    elemMod('strategy', 'different-places')(
        mode('resettable')(true),

        mode('fields')([{ name: 'price', controlType: 'search' }, { name: 'price_context', controlType: 'context' }])
    ),

    //не автобюджетная стратегия для динамических групп, не раздельное размещение
    elemMod('strategy', 'search')(
        mode('resettable')(true),

        mode('fields')([{ name: 'price', controlType: 'search' }])
    ),

    //не автобюджетная стратегия для динамических групп, раздельное размещение, отключены на поиске
    elemMod('strategy', 'net')(
        mode('resettable')(true),

        mode('fields')([{ name: 'price_context', controlType: 'context' }])
    ),

    replace()(function() {
        var cells = apply('cells'),
            attrs;

        // нет ячеек - нет контента
        if (!cells.length) return '';

        // если могут быть заданы общие для кампании ставки, оборачиваем ячейки в блок с переключателем,
        // который реагирует на поле use_default_price и прячет/показывает поля ввода ставки на фильтре
        // ps: для сохранения выравненности колонок используется таблица
        if (apply('resettable') && this.ctx.filter.has_default_price && this.ctx.filter.is_price_editable) {
            attrs = cells.length > 1 && { colspan: cells.length };

            cells = [
                {
                    elem: 'cell',
                    attrs: attrs,
                    content: {
                        elem: 'price-table',
                        elemMods: { collapsed: this.ctx.filter.use_default_price ? 'yes' : '' },
                        tag: 'table',
                        mix: [
                            {
                                elem: 'model-field',
                                js: {
                                    block: 'b-group-feed-filter',
                                    elem: 'price-table',
                                    type: 'mod',
                                    name: 'use_default_price',
                                    modName: 'collapsed'
                                }
                            }
                        ],
                        content: [
                            {
                                elem: 'inputs-row',
                                tag: 'tr',
                                content: cells
                            },
                            {
                                elem: 'reset-row',
                                tag: 'tr',
                                content: {
                                    elem: 'cell',
                                    elemMods: {
                                        'price-mode-toggle': 'yes'
                                    },
                                    mix: {
                                        block: 'b-style-table',
                                        elem: 'cell',
                                        elemMods: { align: 'center' }
                                    },
                                    attrs: attrs
                                }
                            }
                        ]
                    }
                }
            ];
        }

        return cells;
    })
);
