/**
 * Блок-контейнер, содержащий в себе блок фильтра и контролы управления ставкой на фильтре
 *
 * mod strategy: <'default'|'avg-cpa'|'avg-cpc'|'search'|'net'|'different-places'>
 *
 * @param {Object} group объект группы
 * @param {Object} filter объект фильтра (данные из модели)
 * @param {String} nowOptimizingBy ставка действующая на текущий момент
 * @param {Boolean} showStat флаг о необходимости показа полей статистики
 * @param {Boolean} campaignIsArchived флаг архивности кампании
 */
block('b-group-feed-filter')(
    attrs()(function() {
        return { id: 'f-' + this.ctx.filter.filter_id };
    }),

    tag()('tr'),

    js()(function() {
        return {
            modelData: u._.pick(this.ctx.filter, ['filter_id', 'adgroup_id', 'adgroupModelId', 'adgroup_type']),
            modelName: 'vm-feed-filter'
        };
    }),

    match(function() { return this.ctx.filter.is_suspended })
        .def()(function() {
            return applyNext({
                'mods.is-suspended': 'yes'
            });
        }),

    content()(function() {

        return [
            {
                elem: 'cell',
                elemMods: {
                    contents: 'yes',
                    first: 'yes'
                },
                mix: {
                    block: 'b-style-table',
                    elem: 'cell',
                    elemMods: { first: 'yes' }
                },
                content: {
                    block: 'b-feed-filter',
                    mix: {
                        block: 'b-group-feed-filter',
                        elem: 'contents'
                    },
                    filter: this.ctx.filter,
                    platform: this.ctx.platform
                }
            },

            this.ctx.campaignIsArchived && {
                elem: 'cell',
                elemMods: { type: this.mods.first ? 'archived-campaign-warning' : 'gap-cell' },
                cid: this.ctx.group.cid
            },

            +this.ctx.group.is_bs_rarely_loaded == 1 ?  // DIRECT-61956 если есть предупреждение то показываем вместо статитики
                {
                    elem: 'cell',
                    elemMods: { type: 'rarely-served' },
                    group: this.ctx.group
                } :
                this.ctx.showStat ?
                    {
                        elem: 'stats',
                        adgroupType: this.ctx.filter.adgroup_type,
                        filter: this.ctx.filter
                    } :
                    '',

            {
                elem: 'cell',
                elemMods: { type: 'gap-cell' }
            },

            {
                elem: 'price',
                elemMods: { strategy: this.mods.strategy },
                group: this.ctx.group,
                nowOptimizingBy: this.ctx.nowOptimizingBy,
                filter: this.ctx.filter
            }
        ];
    })
);
