BEM.DOM.decl({ block: 'b-group-feed-filter', baseBlock: 'i-glue' }, {

    onSetMod: {

        js: function() {
            this.__base.apply(this, arguments);

            this.model.init().fix();

            // явно задаём модель для блока редактирования (если он есть)
            this.model.get('is_price_editable') &&
                this.findBlocksOn('edit-price', 'b-edit-phrase-price').forEach(function(control) {
                    control.initModels([this.model.getDM()]);
                }, this);

            this._initEvents();
        },

        'is-deleted': function(modName, modVal) {
            // при первом выставлении добавляется контрол восстановления
            if (modVal != 'yes' || this.elem('restore-row').length) return;

            BEM.DOM.append(this.elem('cell', 'first', 'yes'), BEMHTML.apply({
                block: 'b-group-feed-filter',
                elem: 'restore-row',
                filter: this.model.toJSON()
            }));

            this.dropElemCache('restore-row');
        },

        'is-suspended': function(modName, modVal) {
            this.findBlockInside('b-feed-filter').setMod(modName, modVal);
        }

    },

    /**
     * Инициализация событий VM/DM
     */
    _initEvents: function() {
        var fieldsToSync = [];

        this.model.get('is_price_editable') &&
            fieldsToSync.push('price_cpc', 'price_cpa', 'price', 'price_context', 'use_default_price');
        this.model.get('is_settings_editable') && fieldsToSync.push('is_deleted', 'is_suspended');

        fieldsToSync.length &&
            this
                .model
                .on(fieldsToSync.join(' '), 'change', function(e, data) {
                    this.model.getDM().set(data.field, data.value);
                }, this)
                .getDM()
                .on(fieldsToSync.join(' '), 'change', function(e, data) {
                    this.model.set(data.field, data.value);
                }, this);

        this.model.get('is_settings_editable') &&
            this.model.on('is_deleted is_suspended', 'change', function(e, data) {
                this.toggleMod(u.beminize(data.field), 'yes', data.value);
            }, this);

        this.model.getDM().onFirst('destruct', function() { this.destruct(); }, this);
    },

    destruct: function() {
        var block = this.findBlockInside('b-feed-filter');
        block && block.destruct();

        this.__base.apply(this, arguments);
    }

}, {

    live: function() {
        this
            .liveInitOnBlockInsideEvent('init', 'b-feed-filter')
            .liveInitOnBlockInsideEvent('init', 'b-edit-phrase-price')
            .liveBindTo('price-mode-toggle-link', 'click', function() {
                this.model.set('use_default_price', !this.model.get('use_default_price'));
            })
            .liveBindTo('restore', 'click', function() {
                this.model.set('is_deleted', false);
            });
    }

});
