/**
 * @param {Feed[]} this.ctx.feeds список отображаемых фидов
 * @param {String} [this.ctx.selectedFeedId] идентификатор выбранного фида
 */
block('b-group-feed')(
    js()(function() {
        return {
            modelParams: {
                name: 'b-group-feed',
                id: this.ctx.groupId
            }
        }
    }),

    content()(function() {
        var feeds = this.ctx.feeds.map(function(feed) {
                feed.name = u.hellipCut(u.escapeHTML(feed.name), 75);

                return feed;
            }),
            isAnyFeed = feeds && feeds.length,
            selectedFeedId = this.ctx.selectedFeedId,
            selectedFeed = feeds.filter(function(feed) {
                return feed.feed_id == selectedFeedId;
            }).pop();

        return [
            !!isAnyFeed && {
                block: 'dropdown',
                mix: {
                    block: 'b-group-feed',
                    elem: 'dropdown'
                },
                content: [
                    {
                        block: 'button',
                        mix: [
                            {
                                block: 'dropdown',
                                elem: 'switcher'
                            },
                            {
                                block: 'b-group-feed',
                                elem: 'model-field',
                                js: {
                                    type: 'mod',
                                    name: 'arrowDirection',
                                    block: 'button',
                                    modName: 'arrow'
                                }
                            }
                        ],
                        mods: {
                            disabled: this.ctx.disabled ? 'yes' : '',
                            arrow: 'down'
                        },
                        content: {
                            block: 'b-group-feed',
                            elem: 'text',
                            mix: {
                                block: 'b-group-feed',
                                elem: 'model-field',
                                js: {
                                    type: 'inline',
                                    name: 'title'
                                }
                            },
                            content: selectedFeed ? selectedFeed.name : iget2('b-group-feed', 'vyberite-fid', 'Выберите фид')
                        }
                    },
                    {
                        block: 'popup',
                        mods: {
                            disposition: 'dropdown'
                        },
                        js: {
                            directions: [
                                {
                                    to: 'bottom',
                                    axis: 'left',
                                    offset: {
                                        top: 10
                                    }
                                }
                            ]
                        },
                        mix: {
                            block: 'dropdown',
                            elem: 'popup'
                        },
                        content: {
                            elem: 'content',
                            content: {
                                block: 'b-group-feed',
                                elem: 'popup',
                                selectedFeedId: selectedFeedId,
                                feeds: feeds
                            }
                        }
                    }
                ]
            },
            !this.ctx.disabled && {
                block: 'link',
                mods: { inner: 'yes' },
                target: '_blank',
                mix: { block: 'b-group-feed', elem: 'add-feed' },
                url: u.getUrl('showFeeds', {
                    ulogin: u.consts('ulogin')
                }),
                content: [
                    {
                        block: 'icon',
                        mix: { block: 'b-group-feed', elem: 'add-feed-icon' },
                        mods: { 'size-16': 'plus' }
                    },
                    {
                        elem: 'inner',
                        mix: { block: 'b-group-feed', elem: 'add-feed-text' },
                        content: iget2('b-group-feed', 'dobavit', 'Добавить')
                    }
                ]
            }
        ];
    }),

    elem('popup').content()(function() {

        return {
            block: 'b-chooser',
            mix: {
                block: 'b-group-feed',
                elem: 'chooser'
            },
            mods: {
                search: 'yes',
                theme: 'feed'
            },
            content: [
                {
                    elem: 'search'
                },
                {
                    elem: 'wrap',
                    content: this.ctx.feeds.map(function(feed) {
                        return {
                            elem: 'item',
                            elemMods: {
                                selected: feed.feed_id == this.ctx.selectedFeedId ? 'yes' : ''
                            },
                            js: {
                                search: {
                                    title: feed.name,
                                    description: feed.feed_id
                                }
                            },
                            name: feed.feed_id,
                            content: [
                                {
                                    elem: 'title',
                                    content: feed.name
                                },
                                {
                                    elem: 'description',
                                    content: feed.feed_id
                                }
                            ]
                        };
                    }, this)
                },
                {
                    elem: 'not-found'
                }
            ]
        };
    }),

    elem('hint').content()(function() {
        return iget2(
            'b-group-feed',
            'dlya-sozdaniya-gruppy-neobhodimo',
            'Для создания группы необходимо добавить фид на странице «Управление фидами».'
        );
    })
);
