/**
 * Событие выбора фида
 * @event b-group-feed#change
 * @type {Object}
 * @property {String} feed_id идентификатор выбранного фида
 */

/**
 * @fires b-group-feed#change
 */
BEM.DOM.decl({ block: 'b-group-feed', baseBlock: 'i-glue' }, {
    onSetMod: {
        js: function() {
            this.__base();

            this._chooser = this.findBlockOn('chooser', 'b-chooser');
            this._dropdown = this.findBlockOn('dropdown', 'dropdown');

            this._currentFeedName = this._chooser && this._chooser.val();

            this._chooser && this._chooser.on('change', function(e, data) {
                if (data.selected) {
                    this._dropdown.hide();
                    this.model.set('title', data.search.title);
                    this.trigger('change', {
                        prev_feed_id: this._currentFeedName,
                        feed_id: data.name
                    });

                    this._currentFeedName = data.name;
                }
            }, this);

            this._dropdown && this._dropdown.on('show hide', function(e) {
                this.model.set('arrowDirection', e.type == 'show' ? 'up' : 'down');
            }, this);
        }
    },

    /**
     * Задает заданные элемент в b-chooser
     * @param {String} name - имя элемента item
     */
    select: function(name) {
        this._chooser.check(name);
    }
});
