BEM.DOM.decl('b-group-interests', {

    onSetMod: {
        js: function() {
            this._interests = this.params.interests;
            this._selectedInterestsIds = this.params.selectedInterestsIds;
            this._editParamButton = this.findBlockOn('edit-param-button', 'b-edit-param-button');
            this._groupModel = this.params.modelParams && BEM.MODEL.getOne(this.params.modelParams);

            this._editParamButton && this._editParamButton.on('click', this._openEditInterestsPopup, this);
        }
    },

    /**
     * Удаляет блок и подписки на события
     */
    destruct: function() {
        this._editParamButton && this._editParamButton.un('click');

        return this.__base.apply(this, arguments);
    },

    /**
     * Открывает попап редактирования настроек интересов и проводит необходимую инициализацию
     * @private
     */
    _openEditInterestsPopup: function() {
        var popup = BEM.DOM.blocks['b-modal-popup-decorator'].create2(undefined, { bodyScroll: false }, $),
            editInterestsTargetingBlock;

        popup
            .on('close-blocked', function() {
                BEM.blocks['b-confirm'].open({
                    message: iget2('b-group-interests', 'izmeneniya-ne-budut-sohraneny', 'Изменения не будут сохранены. Продолжить?'),
                    onYes: function() {
                        popup.hide({ force: true });
                    }
                });
            }, this)
            .on('close', function() {
                popup.destruct();
            }, this);

        editInterestsTargetingBlock = popup.setPopupContent({
            block: 'b-edit-interests-targeting'
        });

        editInterestsTargetingBlock.init(this._interests, this._selectedInterestsIds);

        editInterestsTargetingBlock.on('cancel', function() {
            popup.hide({ force: true });
        });

        editInterestsTargetingBlock.on('save', function(event, data) {
            this._updateInterestsInfo(data.selectedIds);

            popup.hide({ force: true });
        }, this);

        popup.show();

        this._popup = popup;
    },

    /**
     * Обновляет информацию о выбранных настройках интересов в соответсвии с новыми данными
     * @param {String[]} selectedInterestsIds идентификаторы выбранных интересов
     * @private
     */
    _updateInterestsInfo: function(selectedInterestsIds) {
        this._selectedInterestsIds = selectedInterestsIds;

        this._updateGroupModel();
        this._updateEditParamButton();
    },

    /**
     * Обновляет информацию о выбранных настройках интересов в модели группы
     * @private
     */
    _updateGroupModel: function() {
        var currentInterestsData = this._groupModel.get('target_interests'),
            dataToSave;

        dataToSave = (this._selectedInterestsIds || []).map(function(interestId) {
            return u._.find(currentInterestsData, function(item) { return item.target_category_id == interestId }) ||
                 { target_category_id: interestId };
        });

        this._groupModel.set('target_interests', dataToSave);
    },

    /**
     * Обновляет состояние кнопки и подпись под ней о выбранных категориях интересов
     * @private
     */
    _updateEditParamButton: function() {
        var selectedItemsListText = (this._selectedInterestsIds || []).map(function(interestId) {
            return this._interests[interestId].name;
        }, this).join(', ');

        this._editParamButton.updateParamsSign(selectedItemsListText);
    }
});
