/**
 * Попап для установки автобюджета у фразы
 */
BEM.DOM.decl('b-group-phrase-autobudget', {
    onSetMod: {
        js: function() {
            this._radioButtons = this.findBlockInside('radio-button');
            this._popup = this.findBlockOn('popup')
                .on('hide', this.unbindEvents, this);
        }
    },

    init: function(owner, value) {
        this._owner = owner;
        value && this._radioButtons.val(value) || this._radioButtons.uncheckAll();

        this.bindEvents();

        return this;
    },

    bindEvents: function() {
        this._radioButtons.on('change', function() {
            this._owner.setControlValue(this._radioButtons.val());
        }, this);
    },

    unbindEvents: function() {
        this._radioButtons.un('change');
    },

    hide: function() {
        this._popup.hide();

        return this;
    },

    show: function(owner) {
        this._popup.show(owner);

        return this;
    }

}, {
    getInstance: function() {
        if (this._instance) return this._instance;

        var bPage = BEM.blocks['b-page'].getInstance(),
            radioContent = [];

        $.each({ 1: iget2('b-group-phrase-autobudget', 'nizkiy', 'низкий'), 3: iget2('b-group-phrase-autobudget', 'sredniy', 'средний'), 5: iget2('b-group-phrase-autobudget', 'vysokiy', 'высокий') }, function(value, name) {
            radioContent.push({
                elem: 'radio',
                tag: 'label',
                controlAttrs: { name: 'autobudget_popup', value: value, type: 'radio' },
                mix: [{ block: 'b-group-phrase-autobudget', elem: 'radio' }],
                mods: { side: (value == 1 ? 'left' : value == 5 ? 'right' : 'center'), pressed: 'no' },
                content: [
                    {
                        elem: 'text',
                        content: name
                    }
                ]

            })
        });

        this._instance = $(BEMHTML.apply({
            block: 'popup',
            mix: [{ block: 'b-group-phrase-autobudget', js: true }],
            mods: {
                'has-close': 'yes',
                animate: 'no'
            },
            content: [
                { elem: 'tail' },
                {
                    elem: 'content',
                    mix: [{ block: 'b-group-phrase-autobudget', elem: 'content' }],
                    content: [
                        {
                            block: 'radio-button',
                            name: 'autobudget-btn',
                            mix: [{ block: 'b-group-phrase-autobudget', elem: 'radio-button' }],
                            mods: { size: 's', theme: 'normal' },
                            content: radioContent
                        },
                        {
                            block: 'b-help-link',
                            mods: {
                                type: 'modal'
                            },
                            mix: {
                                block: 'b-group-phrase-autobudget',
                                elem: 'impression-priorities'
                            },
                            stretched: true,
                            url: u.getHelpUrl('impression-priorities')
                        }
                    ]
                }
            ]
        })).appendTo(bPage.domElem).bem('b-group-phrase-autobudget');

        return this._instance;
    }
});
