block('b-group-phrase')(

    attrs()(function() {
        return this.ctx.phrase ?
            { id: 'p-' + this.ctx.phrase.modelId } :
            {};
    }),

    tag()('tr'),

    elem('cell').tag()('td'),

    elem('stat-label-table').tag()('table'),

    elem('stat-label-table-row').tag()('tr'),

    elem('stat-label-table-td').tag()('td'),

    elem('coverage').tag()('span'),

    elem('context-coverage').tag()('span'),

    elem('hidden')(

        tag()('input'),

        attrs()(function() {
            return this._.extend(this.ctx.attrs || {}, {
                type: 'hidden',
                name: this.ctx.name + '',
                value: this.ctx.value + ''
            });
        })
    ),

    elem('help-autotargeting').replace()(function() {
        return {
            block: 'b-help-link',
            mix: [
                {
                    block: 'b-group-phrase',
                    elem: 'help-link'
                },
                {
                    block: 'b-group-phrase',
                    elem: 'help-autotargeting'
                }
            ],
            mods: {
                type: 'modal'
            },
            url: u.getHelpUrl(this.ctx.url),
            title: iget2('b-group-phrase', 'pochemu-zdes-procherk', 'Почему здесь прочерк?')
        };
    })
);

block('b-group-phrase').elem('price-stat-table').content()(function() {
    var ctx = this.ctx,
        phrase = ctx.phrase,
        isMcbanner = ctx.isMcbanner,
        noData = ctx.noData,
        cells;

    // не отображаем торги для условий ретаргетинга и интересов
    if (phrase.is_retargeting || phrase.is_interest) {
        return;
    }

    // для сетей
    if (ctx.isContext) {
        return ['100', '50', '20'].map(function(name) {
            return {
                elem: 'info',
                content: [
                    {
                        elem: 'price-label',
                        content: name + '%'
                    },
                    {
                        elem: 'price-value',
                        content: {
                            elem: 'price-for-coverage-value',
                            phrase: phrase,
                            name: name,
                            noData: noData
                        }
                    }
                ]
            };
        }, this);
    }

    cells = isMcbanner ?
        [{ data: phrase.price_for_mcbanner[0] || {} }] :
        u['traffic-volume'].getTrafficVolumeKeys(phrase.traffic_volume, true).map(function(name) {
            return {
                name: name,
                data: phrase.traffic_volume[name]
            };
        });

    // для поиска и для всех
    return cells.map(function(cell) {
        return {
            elem: 'info',
            content: [
                cell.name && {
                    elem: 'price-label',
                    content: cell.name
                },
                {
                    elem: 'price-value',
                    elemMods: { type: 'bid' },
                    content: cell.data.dont_show_bid_price ?
                        { elem: 'dont-show-bid-price', isMcbanner: isMcbanner } :
                        u.numberFormatter.format(cell.data.bid_price / 1e6)
                },
                {
                    elem: 'price-value',
                    elemMods: { type: 'amnesty' },
                    content: cell.data.dont_show_bid_price ?
                        { elem: 'dont-show-bid-price', isMcbanner: isMcbanner } :
                        u.numberFormatter.format(cell.data.amnesty_price / 1e6)
                }
            ]
        };
    });
});

block('b-group-phrase').elem('current-traffic-volume').content()(function() {
    var phrase = this.ctx.phrase;

    // если для группы не применима логика про торги, то ничего не отрисовываем
    if (!u['traffic-volume'].hasCurrentTrafficVolume(phrase.traffic_volume, phrase.price)) {
        return undefined;
    }

    var value = u['traffic-volume'].getCurrentTrafficVolume(phrase.traffic_volume, phrase.price);

    // getCurrentTrafficVolume может вернуть undefined, если текущая цена меньше минимальной или
    // больше максимальной цены в торгах - в этом случае показываем прочерк и хелп
    return value && value.x ?
        u.numberFormatter.format(value.x, { precision: 0, roundType: 'floor' }) :
        { elem: 'dont-show-current-traffic-volume' };
});

block('b-group-phrase').elem('dont-show-current-traffic-volume').content()(function() {
    var hint = iget2('b-group-phrase', 'dont-show-current-traffic-volume', 'С текущей ставкой ожидается мало показов на поиске.');

    return [
        '&mdash;',
        {
            block: 'b-help-link',
            mix: [
                {
                    block: 'b-hintable-popup',
                    js: {
                        hint: hint,
                        directions: ['bottom'],
                        mixPopup: { block: 'b-group-phrase', elem: 'price-hint-popup' }
                    }
                }
            ]
        }
    ];
});

block('b-group-phrase').elem('price-for-coverage-value').content()(function() {
    var phrase = this.ctx.phrase,
        name = this.ctx.name,
        noData = this.ctx.noData,
        dash = '&mdash;';

    if (noData) {
        return dash;
    }

    if (!phrase.price_for_coverage_visibility[name]) {
        return { elem: 'dont-show-bid-price' };
    }

    return !phrase.price_for_coverage ? dash : phrase.price_for_coverage[name];
});

block('b-group-phrase').elem('dont-show-bid-price').content()(function() {
    var hint = this.ctx.isMcbanner ?
        iget2(
            'b-group-phrase',
            'dont-show-bid-price-hint-b2',
            'Пожалуйста, поработайте над релевантностью баннеров. Если вы видите прочерки вместо ставок, значит баннеру недостаёт качества для показов в некоторых рекламных блоках.'
        ) :
        iget2(
            'b-group-phrase',
            'dont-show-bid-price-hint-o2',
            'Пожалуйста, поработайте над релевантностью объявлений. Если вы видите прочерки вместо ставок, значит объявлению недостаёт качества для показов в некоторых рекламных блоках.'
        );

    return [
        '&mdash;',
        {
            block: 'b-help-link',
            mix: [
                {
                    block: 'b-hintable-popup',
                    js: {
                        hint: hint,
                        directions: ['bottom'],
                        mixPopup: { block: 'b-group-phrase', elem: 'price-hint-popup' }
                    }
                }
            ]
        }
    ];
});
