block('b-group-phrase')(

    def()(function() {
        var phrase = this.ctx.phrase,
            mediaType = this.data.campaign.mediaType;

        phrase.phrase_minus_words_limit = phrase.phrase_minus_words_limit || 20;
        phrase.state = this.ctx.state;
        phrase.parentName = u.campaign.getGroupModelName(mediaType);
        phrase.parentId = this.ctx.group.modelId;
        this.noData = (this.ctx.phrase.is_retargeting || this.ctx.phrase.is_interest ||
            this.ctx.phrase.is_relevance_match ||
            this.ctx.phrase.no_pokazometer_stat || !this.ctx.phrase.pokazometer_data ||
                !this.ctx.phrase.pokazometer_data.shows_list || !this.ctx.phrase.pokazometer_data.shows_list.length);

        return applyNext({
            noData: this.noData,
            phraseModelParams: {
                id: phrase.modelId,
                name: phrase.modelName,
                parentName: phrase.parentName,
                parentId: phrase.parentId
            }
        });
    }),

    js()(function() {
        var mediaType = this.data.campaign.mediaType;

        if (this.data.view_only) {
            return false;
        }

        return {
            noData: this.noData,
            modelParams: this.phraseModelParams,
            groupDMParams: {
                name: u.campaign.getGroupModelName(mediaType),
                id: this.ctx.group.modelId
            },
            campDMParams: {
                name: u.campaign.getCampaignModelName(mediaType),
                id: this.data.campaign.cid
            },
            id: this.ctx.phrase.parentId + '-' + this.ctx.phrase.modelName + '-' + this.ctx.phrase.modelId,
            minusWords: this.ctx.group.minus_words,
            hasTrafficVolume: this.ctx.hasTrafficVolume,
            colsNum: this.ctx.colsNum
        };
    }),

    content()(function() {
        var phrase = this.ctx.phrase,
            data = this.data,
            campaignIsArchived = data.archived == 'Yes',
            campaign = data.campaign,
            strategy = campaign.strategy,
            canEditText = !campaign.readonly && !this.ctx.readonly,
            isLimitedSupport = data.login_rights.limited_support_control,
            isRelevanceMatchReadOnly = phrase.is_relevance_match && !canEditText,
            interestDisabled = phrase.is_interest && strategy.is_net_stop,
            retargetingDisabled = u.consts('isSearchRetargetingEnabled') ?
                false :
                phrase.is_retargeting && strategy.is_net_stop,
            isAutobudget = strategy.is_autobudget,
            isOutdoor = this.ctx.group.cpm_banners_type === 'cpm_outdoor',
            isIndoor = this.ctx.group.cpm_banners_type === 'cpm_indoor',
            mediaType = campaign.mediaType,
            isCpmBanner = u.campaign.isCpm(mediaType),
            conditionType = phrase.is_phrase ?
                'phrase' :
                phrase.is_interest ?
                    'interest' :
                    phrase.is_relevance_match ?
                        'relevance-match' :
                        'retargeting',
            canViewCompetitors = !campaignIsArchived && !isRelevanceMatchReadOnly,
            isContentPromotion = campaign.mediaType === 'content_promotion',
            disabledHints = {
                rmPriority: iget2(
                    'b-group-phrase',
                    'prioritet-dlya-avtotargetinga-nelzya',
                    'Приоритет для автотаргетинга нельзя установить, так как показы на поиске запрещены настройками стратегии'
                ),
                rmBid: iget2(
                    'b-group-phrase',
                    'stavku-dlya-avtotargetinga-nelzya',
                    'Ставку для автотаргетинга нельзя установить, так как показы на поиске запрещены настройками стратегии'
                ),
                interestPriority: iget2(
                    'b-group-phrase',
                    'prioritet-dlya-interesov-k',
                    'Приоритет для интересов к мобильным приложениям нельзя установить, так как показы в сетях запрещены настройками стратегии'
                ),
                interestBid: iget2(
                    'b-group-phrase',
                    'stavku-dlya-interesov-k',
                    'Ставку для интересов к мобильным приложениям нельзя установить, так как показы в сетях запрещены настройками стратегии'
                ),
                retargetingPriority: iget2(
                    'b-group-phrase',
                    'prioritet-dlya-usloviy-podbora',
                    'Приоритет для условий подбора аудитории нельзя установить, так как показы в сетях запрещены настройками стратегии'
                ),
                retargetingBid: iget2(
                    'b-group-phrase',
                    'stavku-dlya-usloviy-podbora',
                    'Ставку для условий подбора аудитории нельзя установить, так как показы в сетях запрещены настройками стратегии'
                )
            },
            disabledKey = interestDisabled ?
                'interest' :
                retargetingDisabled ?
                    'retargeting' :
                    '',
            statFields,
            isRetargetingInterests = this.ctx.phraseType === 'retargetingInterests',
            res = [
                {
                    block: 'b-group-phrase',
                    elem: 'cell',
                    mix: [{
                        block: 'b-style-table',
                        elem: 'cell',
                        elemMods: {
                            first: 'yes'
                        }
                    }],
                    elemMods: {
                        'relevance-match-cell': phrase.is_relevance_match && isAutobudget ?
                            'title' :
                            ''
                    },
                    content: {
                        block: 'b-phrase',
                        mods: {
                            type: conditionType,
                            new: phrase.flag_new ? 'yes' : '',
                            editable: (isLimitedSupport || canEditText) && !isRetargetingInterests ? 'yes' : 'no',
                            clickable: conditionType !== 'retargeting' && canViewCompetitors && !isRetargetingInterests ? 'yes' : 'no',
                            'minus-words-type': data.view_only ||
                                (phrase.phrase_minus_words_limit < phrase.phrase_minus_words_length ||
                                    this.ctx.group.minus_words && this.ctx.group.minus_words.length ||
                                    (data.campaign.minus_words && data.campaign.minus_words.minus_words &&
                                        data.campaign.minus_words.minus_words.length)) ?
                                'popup' : 'inline'
                        },
                        js: {
                            modelParams: this.phraseModelParams,
                            groupDMParams: {
                                name: u.campaign.getGroupModelName(mediaType),
                                id: this.ctx.group.modelId
                            },
                            campDMParams: {
                                name: u.campaign.getCampaignModelName(mediaType),
                                id: this.data.campaign.cid
                            }
                        },
                        phrase: phrase,
                        phraseModelId: this.phraseModelParams.id,
                        platform: this.ctx.platform,
                        group: this.ctx.group
                    }
                }
            ],
            groupHasOnlyCpcVideoAndImageAds = this.ctx.groupHasOnlyCpcVideoAndImageAds,
            platform = this.ctx.platform,
            statFieldsToFormatInt;

        // заглушка если в группе только графические объявления
        // вместо столбца производительность - пустой столбец
        groupHasOnlyCpcVideoAndImageAds && platform !== 'context' && res.push({
            block: 'b-group-phrase',
            elem: 'cell'
        });

        // блок статистики (показы, клики, ctr в зависимости от типа кампании и стратегии)
        if (this.data.showStat && platform === 'context') {

            if (isCpmBanner) {
                // Если (outdoor || indoor) – столбики "Клики" и "CTR" не нужны
                statFields = isOutdoor || isIndoor ? ['ctx_shows'] : ['ctx_shows', 'ctx_clicks', 'ctx_ctr'];
            } else {
                statFields = ['ctx_clicks'];
            }

            statFieldsToFormatInt = isCpmBanner ? ['ctx_shows', 'ctx_clicks'] : [];

            res.concat(statFields.map(function(name) {
                res.push({
                    block: 'b-group-phrase',
                    elem: 'cell',
                    mix: [{
                        block: 'b-style-table',
                        elem: 'cell',
                        elemMods: {
                            align: 'center'
                        }
                    }],
                    content: {
                        elem: u.beminize(name),
                        content: u._.contains(statFieldsToFormatInt, name) ?
                            u.numberFormatter.format(phrase[name], {
                                precision: 0,
                                exponentDelimiter: '&nbsp;',
                                fail: '0'
                            }) :
                            phrase[name] || '0'
                    }
                });
            }));
        } else if (this.data.showStat) {

            statFields = this.ctx.hasTrafficVolume && u.consts('enableWCTR') ?
                ['effective_ctr', 'shows', 'clicks', 'ctr'] :
                ['shows', 'clicks', 'ctr'];

            res.concat(statFields.map(function(name) {
                var content,
                    field;

                if (platform === 'search' && groupHasOnlyCpcVideoAndImageAds) {
                    content = '—';
                } else {
                    field = phrase.is_retargeting || phrase.is_interest || groupHasOnlyCpcVideoAndImageAds ? 'ctx_' + name : name;
                    content = field === 'effective_ctr' ? u.numberFormatter.format(phrase[field]) : phrase[field];
                }

                res.push({
                    block: 'b-group-phrase',
                    elem: 'cell',
                    elemMods: { baseline: mediaType === 'mcbanner' ? 'yes' : '' },
                    mix: [{
                        block: 'b-style-table',
                        elem: 'cell',
                        elemMods: {
                            align: 'center'
                        }
                    }],
                    content: {
                        elem: name,
                        content: content
                    }
                });
            }));
        }

        // блок торгов
        if ((!groupHasOnlyCpcVideoAndImageAds || platform == 'context') && !isCpmBanner) {
            // не показываем торги для архивных кампаний - вместо этого даём ссылку на мастер отчетов (DIRECT-62540)
            if (campaignIsArchived) {
                res.push({
                    block: 'b-group-phrase',
                    elem: 'cell',
                    attrs: {
                        colspan: 2
                    },
                    mix: [
                        {
                            elem: 'archived-camp-stat-warning'
                        },
                        {
                            block: 'b-style-table',
                            elem: 'cell',
                            elemMods: {
                                align: 'right'
                            }
                        }
                    ],
                    content: this.ctx.isFirst ?
                        iget2('b-group-phrase', 'statistika-po-arhivnym-kampaniyam', 'Статистика по архивным кампаниям доступна в {link}', {
                            link: function(text) {
                                return {
                                    block: 'link',
                                    url: u.getUrl('showStat', {
                                        stat_type: 'moc',
                                        single_camp: 1,
                                        with_auto_added_phrases: 1,
                                        isStat: 1,
                                        cid: data.campaign.cid,
                                        ulogin: u.consts('ulogin')
                                    }),
                                    content: text
                                };
                            }(iget2('b-group-phrase', 'statistika-po-arhivnym-kampaniyam-param-link', 'Мастере отчетов')),

                            context: 'link - Мастере отчетов'
                        }) :
                        ''
                });
            } else if (+this.ctx.group.is_bs_rarely_loaded == 1) { // флаг "Мало показов" DIRECT-51298
                res.push({
                    block: 'b-group-phrase',
                    elem: 'cell',
                    attrs: {
                        colspan: 2
                    },
                    mix: [
                        {
                            block: 'b-style-table',
                            elem: 'cell',
                            elemMods: {
                                align: 'right',
                                valign: 'middle'
                            }
                        }
                    ],
                    content: {
                        block: 'b-rarely-served-message',
                        adgroupType: this.ctx.group.adgroup_type,
                        phraseType: this.ctx.phraseType
                    }
                });
            } else if (phrase.nobsdata || phrase.rank <= this.data.MIN_PHRASE_RANK_WARNING) {
                //фраза отключена
                if (phrase.nobsdata) {
                    res.push({
                        block: 'b-group-phrase',
                        elem: 'cell',
                        attrs: {
                            colspan: 2
                        },
                        mix: [{
                            block: 'b-style-table',
                            elem: 'cell'
                        }],
                        content: iget2('b-group-phrase', 'po-tehnicheskim-prichinam-vremenno', 'По техническим причинам временно нет данных')
                    });
                } else {
                    //Фраза показывается в сети
                    if (phrase.context_editable_price) {
                        if (platform == 'context') {
                            res = res.concat(apply('priceStat', {
                                phrase: phrase,
                                platform: platform
                            }));
                        } else {
                            res.push({
                                block: 'b-group-phrase',
                                elem: 'cell',
                                attrs: {
                                    colspan: 2
                                },
                                phrase: this.ctx.phrase
                            });
                        }
                    } else {
                        res.push({
                            block: 'b-group-phrase',
                            elem: 'cell',
                            attrs: {
                                colspan: 2
                            },
                            mix: [{
                                block: 'b-style-table',
                                elem: 'cell'
                            }],
                            content: {
                                elem: 'info',
                                content: iget2('b-group-phrase', 'fraza-otklyuchena-za-nizkiy', 'Фраза отключена за низкий CTR')
                            }
                        });
                    }
                }

                //фраза отклонена
            } else if (phrase.declined) {
                res.push({
                    block: 'b-group-phrase',
                    elem: 'cell',
                    attrs: {
                        colspan: 2
                    },
                    mix: [{
                        block: 'b-style-table',
                        elem: 'cell'
                    }],
                    content: {
                        elem: 'info',
                        content: iget2('b-group-phrase', 'fraza-otklonena-na-moderacii', 'Фраза отклонена на модерации')
                    }
                });
                //с фразой всё хорошо
            } else {
                res = res.concat(apply('priceStat', {
                    phrase: phrase,
                    platform: platform
                }));
            }
        }

        // нет приоритета на автобюджетных стратегиях для кампаний cpm_banner и cpm_deals
        !isAutobudget && res.push({
            block: 'b-group-phrase',
            elem: 'cell',
            elemMods: {
                'relevance-match-cell': phrase.is_relevance_match && !isAutobudget ?
                    (!!this.data.view_only || !this.ctx.group.editable_price ||
                    platform === 'search' && groupHasOnlyCpcVideoAndImageAds) ?
                        'wrapper' :
                        'input' :
                    ''
            },
            mix: [{
                block: 'b-style-table',
                elem: 'cell',
                elemMods: {
                    align: isContentPromotion ? 'right' : 'center'
                }
            }],
            attrs: isContentPromotion && {
                colspan: 2
            },
            content: {
                block: 'b-group-phrase',
                elem: 'price',
                elemMods: {
                    key: disabledKey,
                    full: disabledKey + (isAutobudget ? 'Priority' : 'Bid')
                },
                platform: platform,
                phrase: phrase,
                group: this.ctx.group,
                groupHasOnlyCpcVideoAndImageAds: groupHasOnlyCpcVideoAndImageAds,
                disabled: interestDisabled || retargetingDisabled,
                disabledHintText: disabledHints[disabledKey + (isAutobudget ? 'Priority' : 'Bid')] || ''
            }
        });

        if (platform === 'context' && !isCpmBanner) {
            res.push({
                block: 'b-group-phrase',
                elem: 'cell',
                mix: [
                    {
                        block: 'b-style-table',
                        elem: 'cell',
                        elemMods: {
                            align: 'center'
                        }
                    }
                ],
                content: {
                    elem: 'context-coverage-wrapper',
                    phrase: phrase,
                    platform: platform,
                    isCpmBanner: isCpmBanner
                }
            });
        }

        // текущий объём трафика
        if (this.ctx.hasTrafficVolume && !isAutobudget && !isContentPromotion) {
            res.push({
                block: 'b-group-phrase',
                elem: 'cell',
                mix: [{
                    block: 'b-style-table',
                    elem: 'cell',
                    elemMods: {
                        align: 'center'
                    }
                }],
                content: {
                    elem: 'current-traffic-volume',
                    phrase: phrase
                }
            });
        }

        return res;
    }),

    mode('priceStat')(function() {
        var res = [],
            phrase = this.phrase,
            isRelevanceMatch = this.phrase.is_relevance_match,
            isContext = this.platform === 'context',
            isMcbanner = this.data.campaign.mediaType === 'mcbanner',
            isContentPromotion = this.data.campaign.mediaType === 'content_promotion';

        res.push({
            block: 'b-group-phrase',
            elem: 'cell',
            mix: [{
                block: 'b-style-table',
                elem: 'cell'
            }],
            elemMods: {
                baseline: isMcbanner ? 'yes' : ''
            },
            attrs: {
                colspan: 2
            },
            content: !isRelevanceMatch && !isContentPromotion && {
                elem: 'price-stat-table',
                elemMods: { 'is-context': isContext ? 'yes' : 'no' },
                phrase: phrase,
                isContext: isContext,
                isMcbanner: isMcbanner,
                noData: this.noData
            }
        });

        return res;
    })
);

block('b-group-phrase').elem('price').content()(function() {
    var controlType,
        phrase = this.ctx.phrase,
        platform = this.ctx.platform,
        groupHasOnlyCpcVideoAndImageAds = this.ctx.groupHasOnlyCpcVideoAndImageAds,
        campDMParams = {
            name: u.campaign.getCampaignModelName(this.data.campaign.mediaType),
            id: this.data.campaign.cid
        },
        disabled = this.ctx.disabled ? 'yes' : '',
        disabledHintText = this.ctx.disabledHintText,
        autobudget = this.data.campaign.autobudget;

    if (platform === 'search') {
        controlType = 'search';
    } else if (phrase.is_relevance_match && autobudget !== 'Yes') {
        controlType = platform === 'context' ? 'context' : 'search';
    } else if (platform === 'context' && autobudget === 'No') {
        controlType = 'context';
    } else if (autobudget === 'Yes') {
        controlType = 'autobudget';
    } else if (phrase.search_editable_price) {
        controlType = 'search';
    } else if (phrase.context_editable_price) {
        controlType = 'context';
    } else if (phrase.rank > this.data.MIN_PHRASE_RANK_WARNING && phrase.declined) {
        controlType = 'search';
    } else if (!phrase.context_stop_flag && phrase.declined) {
        controlType = 'context';
    } else {
        controlType = 'low-ctr';
    }

    if (controlType === 'autobudget') {
        return '';
    }

    var price = controlType == 'search' ? phrase.price : phrase.price_context,
        editable = (controlType == 'search') ?
            this.ctx.phrase.search_editable_price :
            this.ctx.phrase.search_editable_price || this.ctx.phrase.context_editable_price,
            // Графические объявления показываются только в сетях
            // поэтому вместо цены на поиске - прочерк
        hasNoPrice = platform === 'search' && groupHasOnlyCpcVideoAndImageAds;

    return !!this.data.view_only || !this.ctx.group.editable_price || hasNoPrice ?
        {
            elem: 'price-wrapper',
            content: hasNoPrice ? '&mdash;' : price
        } :
        !editable ?
            '&mdash;' :
            {
                block: 'b-edit-phrase-price',
                price: price,
                phrase: this.ctx.phrase,
                campDMParams: campDMParams,
                group: this.ctx.group,
                platform: this.ctx.platform,
                name: (controlType == 'search' ? 'val' : 'ctx_val'),
                hasError: this.ctx.phrase.errors[controlType == 'search' ? 'price' : 'price_context'],
                hasWarning: this.ctx.phrase.warnings[controlType == 'search' ? 'price' : 'price_context'],
                mods: {
                    'control-type': controlType,
                    disabled: disabled
                },
                disabledHintText: disabledHintText
            };
});

block('b-group-phrase').elem('context-coverage-wrapper').content()(function() {
    var res = [],
        phrase = this.ctx.phrase;

    if (
        (phrase.search_editable_price || phrase.context_editable_price) &&
        !phrase.is_relevance_match &&
        !this.ctx.isCpmBanner
    ) {
        if (phrase.is_retargeting || phrase.is_interest || this.noData) {
            res.push(
                {
                    elem: 'context-coverage',
                    content: '&mdash;'
                },
                {
                    block: 'b-help-link',
                    mods: {
                        type: 'modal'
                    },
                    url: phrase.is_retargeting ?
                        u.getHelpUrl('retargeting-dash') : phrase.is_interest ?
                        u.getHelpUrl('interest-targeting-dash') : u.getHelpUrl('audience-coverage-dash'),
                    title: iget2('b-group-phrase', 'pomoshch', 'Помощь')
                }
            );
        } else {
            res.push({
                elem: 'context-coverage',
                content: (phrase.context_coverage || 0) + '%'
            });
        }
    }

    return res;
});
