(function() {
    BEM.DOM.decl({ block: 'b-group-phrase', baseBlock: 'i-glue' }, {
        onSetMod: {
            js: function() {
                this.modelParams = this.params.modelParams;

                this._initModel(this.modelParams);

                this.bannersGroupModel = BEM.MODEL.getOrCreate({
                    id: this.modelParams.parentId,
                    name: this.modelParams.parentName
                });

                this.campaignModel = BEM.MODEL.getOne(this.params.campDMParams);

                this.bindEvents();
                this.priceControls = {};
                this.initControls();
            }
        },

        /**
         * Возвращаем модель m-phrase-bidable соответствующую данному блоку
         * @returns {BEM.MODEL}
         */
        getModel: function() {
            return this.model;
        },

        /**
         * Инициализируем контролы
         * @returns {BEM}
         */
        initControls: function() {
            var priceControls = this.findBlocksInside('b-edit-phrase-price');

            priceControls && priceControls.forEach(function(control) {
                control.initModels([this.model]);
                this.priceControls[control.getMod('control-type')] = control;
            }, this);

            this.findBlocksInside('b-phrase');

            return this;
        },

        /**
         * Привязываем колбэки к событиям модели
         * @returns {BEM}
         */
        bindEvents: function() {
            var modelName = this.model.name,
                fields = ['min_price', 'price_context'];

            if (modelName !== 'm-retargeting-bidable' && modelName !== 'm-interest-bidable') {
                fields.push('autobroker', 'price')
            }

            this.model
                .on(fields.join(' '), 'change', $.debounce(this.onModelChanged, 50, this))
                .on('price_for_mcbanner traffic_volume', 'change',
                    $.debounce(this._onBidsChanged.bind(this, false), 50))
                .on('price_for_coverage', 'change',
                    $.debounce(this._onBidsChanged.bind(this, true), 50))
                .on('is_deleted', 'change', this._onPhraseDelete, this)
                .on('is_suspended', 'change', function() {
                    this.setMod('is-suspended', this.model.get('is_suspended') ? 'yes' : '');
                }, this);

            BEM.MODEL.on(this.getModelParams(), 'destruct', this._onPhraseDeleteComplete, this);

            return this;
        },

        /**
         * Возвращает BEM-блок для удалённой фразы
         * @returns {BEM}
         */
        _getDeleted: function() {
            return this.deleted || (this.deleted = $(BEMHTML.apply({
                block: 'b-group-phrase',
                js: {
                    modelParams: this.modelParams,
                    isRetargeting: this.model.name == 'm-retargeting-bidable',
                    isInterest: this.model.name == 'm-interest-bidable',
                    isRelevanceMatch: this.model.name == 'm-relevance-match'
                },
                colspan: this.params.colsNum,
                mods: { deleted: 'yes', type: this.getMod('type') },
                phrase: { id: this.params.modelId }
            })).insertAfter(this.domElem).bem('b-group-phrase'));
        },

        /**
         * Обработчик изменения значения флага deleted у модели
         * @returns {BEM}
         * @private
         */
        _onPhraseDelete: function(e, data) {
            var isDeleted = this.model.get('is_deleted'),
                deleted = this._getDeleted(),
                fieldName = this.model.name == 'm-retargeting-bidable' ?
                    'condition_name_escape' :
                    this.model.name == 'm-interest-bidable' ?
                        'interest_name_escape' :
                        'key_words_short';

            isDeleted && deleted
                .setDeletedText(this.model.get(fieldName))
                .delMod('hidden');
            !isDeleted && deleted.setMod('hidden', 'yes');

            this.setMod('hidden', isDeleted ? 'yes' : '');

            return this;
        },

        /**
         * @private
         */
        _onPhraseDeleteComplete: function() {
            //инициализируем группу к которой принадлежит фраза - возможно придется скрывать заголовок
            this.findBlockOutside('b-phrases-list');
            this.trigger('destruct');
            this.deleted && this.deleted.destruct();
            this.destruct();
        },

        /**
         * Колбэк на изменение модели
         */
        onModelChanged: function() {
            if (this.model.get('is_deleted')) return;

            //для контекста
            this.priceControls.context && this._updateContextCoverage();
            this.priceControls.search && this._updateCurrentTrafficVolume();
        },

        /**
         * Колбэк на изменение ставок, нужно перерисовать их в таблице
         * @private
         */
        _onBidsChanged: function(isContext) {
            var isMcbanner = this.campaignModel.get('mediaType') === 'mcbanner',
                noData = this.params.noData,
                phrase = this.model.toJSON(),
                isContextValue = isContext ? 'yes' : 'no';

            // обновляем торги
            BEM.DOM.replace(
                this.findElem('price-stat-table', 'is-context', isContextValue),
                BEMHTML.apply({
                    block: 'b-group-phrase',
                    elem: 'price-stat-table',
                    elemMods: { 'is-context': isContextValue },
                    phrase: phrase,
                    isMcbanner: isMcbanner,
                    isContext: isContext,
                    noData: noData
                }));

            this._updateCurrentTrafficVolume();
        },

        _updateCurrentTrafficVolume: function() {
            var phrase = this.model.toJSON(),
                visitParams = {},
                value = u['traffic-volume'].getCurrentTrafficVolume(phrase.traffic_volume, phrase.price);

            // обновляем текущий объём трафика
            BEM.DOM.replace(
                this.findElem('current-traffic-volume'),
                BEMHTML.apply({
                    block: 'b-group-phrase',
                    elem: 'current-traffic-volume',
                    phrase: phrase
                }));

            // DIRECT-79202 логируем изменение ставок для трафаретных торгов
            if (value) {
                visitParams[Math.round(value.x)] = value.price;

                BEM.blocks['b-metrika2'].params({
                    params: {
                        'change-current-traffic-volume': visitParams
                    }
                });
            }

        },

        /**
         * Обновляем охват аудитории
         * @returns {BEM}
         * @private
         */
        _updateContextCoverage: function() {
            var model = this.model;

            if (!model.get('is_retargeting')) {
                //для фраз, по которым в показометре нет статистики кликов ничего не меняем
                var pokazometerData = model.get('pokazometer_data');

                if (model.get('no_pokazometer_stat') == 1 ||
                    !pokazometerData ||
                    !pokazometerData.shows_list ||
                    !pokazometerData.shows_list.length) return this;

                model.set(
                    'context_coverage',
                    BEM.blocks['i-autobroker'].calcContextCoverage(
                        model.get('price_context') * 1e6,
                        pokazometerData
                    ) * 100
                );
                this.elem('context-coverage').html(model.get('context_coverage', 'format') + '%');
            }

            return this;
        },

        /**
         * Возвращает экземпляр попапа
         * @returns {BEM}
         * @private
         */
        getPopup: function() {
            return this._popup || (this._popup = BEM.blocks['b-shared-popup'].getInstance({
                adaptive: 'yes'
            }));
        },

        /**
         * Возвращает подсказку для элемента amnesty-price
         * @returns {BEM}
         */
        _getAmnestyPriceHelp: function() {
            return this._amnestyPriceHelp || (this._amnestyPriceHelp = BEMHTML.apply({
                block: 'b-group-phrase',
                elem: 'amnesty-price-help',
                content: [
                    iget2('b-group-phrase', 'spisyvaemaya-cena-pri-razmeshchenii', 'Списываемая цена при размещении на позиции'),
                    {
                        block: 'b-help-link',
                        mix: [{ block: 'b-group-phrase', elem: 'amnesty-price-help-link' }],
                        url: u.getHelpUrl('cost-per-click')
                    }
                ]
            }));
        },

        /**
         * Показывает подсказку к элементу amnesty-price с ссылкой на help
         *
         * @param {Object} elem элемент amnesty-price
         */
        showTooltip: function(elem) {
            this.getPopup()
                .setContent(this._getAmnestyPriceHelp())
                .toggle(elem);
        }

    }, {
        live: function() {
            this
                .liveInitOnBlockInsideEvent('init', 'b-edit-phrase-price')
                .liveBindTo('amnesty-price', 'click', function(e) {
                    this.showTooltip(this.elemify(e.target));
                });
        }
    });

})();
