block('b-group-preview2').elem('banners')(
    replace()(function() {
        return this.ctx.vmData ? {
            block: 'popup',
            elem: 'body',
            content: {
                block: 'b-group-preview2',
                elem: 'list',
                vmData: this.ctx.vmData,
                bannerAimingAllowed: this.ctx.bannerAimingAllowed
            }
        } : '';
    }),

    elem('list').js()(true),

    elem('list').content()(function() {
        var vmData = this.ctx.vmData, bannerAimingAllowed = this.ctx.bannerAimingAllowed, cid = vmData.cid;

        return vmData.shownBannersData.map(function(bannerData) {
            var tab = vmData.tab,
                bid = bannerData.bid,
                bidName = '№&nbsp;M-' + bid,
                can = bannerData.can,
                bannerId = bannerData.bannerId,
                isNotNewBanner = !bannerData.isNewBanner,
                showAimingBtn = bannerAimingAllowed && bannerAimingAllowed.isFeatureEnabled &&
                    tab.indexOf('search') === -1,
                enableAimingBtn = bannerAimingAllowed && bannerAimingAllowed.isCampaignRunning &&
                    bannerData.statusModerate === 'Yes' && bannerData.statusBsSynced === 'Yes',
                placementPages = bannerData.statusCtx.banner.placement_pages || [],
                enableStatusOutDoorPlacementPages = placementPages.length,
                bidTitle = (Number(bannerId) && u.consts('rights').showBannerIdInfo) ?
                    iget2('b-group-preview2', 'banner-id', '{bidName} (БК: {bannerId})', { bannerId: bannerId, bidName: bidName }) :
                    bidName;

            return {
                elem: 'banner-item',
                elemMods: {
                    off: bannerData.isShown ? '' : 'yes',
                    bid: bid
                },
                content: [
                    {
                        elem: 'banner-title',
                        content: [
                            {
                                elem: 'banner-title-bid',
                                content: bid == 0 ?
                                    iget2('b-group-preview2', 'novoe-obyavlenie', 'Новое объявление') :
                                    bidTitle
                            }, '&nbsp', bannerData.isMobile && {
                                elem: 'banner-title-note',
                                content: '(' + iget2('b-group-preview2', 'mobilnoe', 'мобильное') + ')'
                            }
                        ]
                    }, {
                        elem: 'inline-helper',
                        content: [
                            !vmData.readonly && {
                                elem: 'banner-controls',
                                content: [
                                    {
                                        elem: 'controls-row',
                                        content: {
                                            block: 'tumbler',
                                            mods: {
                                                disabled: can.changeShownStatus ? '' : 'yes',
                                                checked: bannerData.isShown ? 'yes' : ''
                                            },
                                            mix: [
                                                {
                                                    block: 'b-group-preview2',
                                                    elem: 'action-shown-status',
                                                    js: {
                                                        bid: bid
                                                    }
                                                }
                                            ]
                                        }
                                    }, can.archive && isNotNewBanner && {
                                        elem: 'controls-row',
                                        content: {
                                            block: 'button',
                                            mods: {
                                                size: 'xs',
                                                theme: 'normal'
                                            },
                                            mix: [
                                                {
                                                    block: 'b-group-preview2',
                                                    elem: 'control',
                                                    elemMods: {
                                                        action: 'archive'
                                                    },
                                                    js: {
                                                        bid: bid
                                                    }
                                                }
                                            ],
                                            content: iget2('b-group-preview2', 'arhivirovat', 'Архивировать')
                                        }
                                    }, can['delete'] && isNotNewBanner && {
                                        elem: 'controls-row',
                                        content: {
                                            block: 'button',
                                            mods: {
                                                size: 's',
                                                theme: 'normal'
                                            },
                                            mix: [
                                                {
                                                    block: 'b-group-preview2',
                                                    elem: 'control',
                                                    elemMods: {
                                                        action: 'delete'
                                                    },
                                                    js: {
                                                        bid: bid
                                                    }
                                                }
                                            ],
                                            content: iget2('b-group-preview2', 'udalit', 'Удалить')
                                        }
                                    }, can.unArchive && isNotNewBanner && {
                                        elem: 'controls-row',
                                        content: {
                                            block: 'button',
                                            mods: {
                                                size: 'xs',
                                                theme: 'normal'
                                            },
                                            mix: [
                                                {
                                                    block: 'b-group-preview2',
                                                    elem: 'control',
                                                    elemMods: {
                                                        action: 'unarchive'
                                                    },
                                                    js: {
                                                        bid: bid
                                                    }
                                                }
                                            ],
                                            content: iget2('b-group-preview2', 'razarhivirovat', 'Разархивировать')
                                        }
                                    }, can.edit && isNotNewBanner && {
                                        elem: 'controls-row',
                                        content: {
                                            block: 'button',
                                            mods: {
                                                size: 'xs',
                                                theme: 'normal'
                                            },
                                            mix: [
                                                {
                                                    block: 'b-group-preview2',
                                                    elem: 'control',
                                                    elemMods: {
                                                        action: 'edit'
                                                    },
                                                    js: {
                                                        bid: bid
                                                    }
                                                }
                                            ],
                                            url: ['mobile_content', 'dynamic', 'mcbanner', 'cpm_yndx_frontpage'].some(function(type) { return type === vmData.adgroupType; }) ?
                                                u.formatUrl({
                                                    path: '/registered/main.pl',
                                                    query: {
                                                        cmd: u.campaign.getEditCmdByMediaType(vmData.adgroupType),
                                                        bids: bid,
                                                        adgroup_ids: vmData.adgroupId,
                                                        cid: vmData.cid,
                                                        ulogin: u.consts('ulogin')
                                                    }
                                                }) :
                                                u.getEditBannersInNewInterfaceUrl(false, {
                                                    ulogin: u.consts('ulogin'),
                                                    cid: vmData.cid,
                                                    adgroupId: vmData.adgroupId,
                                                    bids: [bid]
                                                }),
                                            content: iget2('b-group-preview2', 'redaktirovat', 'Редактировать')
                                        }
                                    }
                                ]
                            },
                            {
                                elem: 'banner-body',
                                content: u.deepExtend({
                                    block: 'b-banner-preview2',
                                    staticData: {
                                        geo: ''
                                    }
                                }, bannerData.previewCtx)
                            },
                            {
                                elem: 'banner-warn',
                                content: [
                                    showAimingBtn && {
                                        block: 'b-banner-aiming-button',
                                        mix: [
                                            {
                                                block: 'b-group-preview2',
                                                elem: 'banner-aiming-btn'
                                            }
                                        ],
                                        disabled: !enableAimingBtn,
                                        bid: bidName,
                                        bannerId: bid,
                                        cid: cid,
                                        ulogin: u.consts('ulogin')
                                    },

                                    enableStatusOutDoorPlacementPages ?
                                        '' :
                                        u.deepExtend(
                                            { block: 'b-banner-status', mods: { updatable: 'yes' } },
                                            bannerData.statusCtx
                                        ),
                                    vmData.statusMetricaStop && { block: 'b-metrica-stop-warning' },
                                    enableStatusOutDoorPlacementPages ?
                                        [
                                            u.deepExtend(
                                                { block: 'b-banner-status', mods: { updatable: 'yes' } },
                                                bannerData.statusCtx
                                            ),
                                            {
                                                block: 'b-remoderated-outdoor',
                                                mods: {
                                                    sent: u.consts('outDoorPlacementsReModerate') ?
                                                        'yes' :
                                                        undefined,
                                                    info: u.consts('rights').showBannerIdInfo ?
                                                        'yes' :
                                                        undefined,
                                                },
                                                mix: {
                                                    block: this.block,
                                                    elem: 'remoderated-outdoor'
                                                },
                                                bid: bid,
                                                placementPages: placementPages
                                            }
                                        ] :
                                        ''
                                ]
                            }
                        ]
                    }
                ]
            };
        }, this);
    }));
