block('b-group-preview2').elem('footer')(

    mix()([{
        block: 'popup',
        elem: 'controls'
    }]),

    content()(function() {
        var vmData = this.ctx.vmData,
            archiveCount = vmData.countArchiveBanners,
            tabIsArchive = vmData.tabIsArchive,
            isAllArchived = !vmData.countNoArchiveBanners,
            result = [],
            showNoOneBid = !vmData.showOneBid;

        showNoOneBid && tabIsArchive && !isAllArchived && result.push({
            block: 'link',
            mods: {
                pseudo: 'yes',
                theme: 'without-border'
            },
            mix: [{
                block: 'b-group-preview2',
                elem: 'control',
                elemMods: {
                    action: 'go-no-archive'
                }
            }],
            content: vmData.adgroupType == 'mcbanner' ? iget2('b-group-preview2', 'vse-bannery', 'Все баннеры') : iget2('b-group-preview2', 'vse-obyavleniya', 'Все объявления')
        });

        !vmData.readonly && (result = result.concat(tabIsArchive ?
            showNoOneBid && {
                block: 'button',
                mix: [{
                    block: 'b-group-preview2',
                    elem: 'control',
                    elemMods: {
                        action: 'unarchive-all'
                    }
                }],
                content: isAllArchived ? iget2('b-group-preview2', 'razarhivirovat-gruppu', 'Разархивировать группу') : iget2('b-group-preview2', 'razarhivirovat-vse', 'Разархивировать все')
            } :
            [
                {
                    block: 'button',
                    mods: {
                        disabled: this.ctx.vmData.hasChangedStatuses ? '' : 'yes'
                    },
                    mix: [{
                        block: 'b-group-preview2',
                        elem: 'control',
                        elemMods: {
                            action: 'save'
                        }
                    }],
                    content: iget2('b-group-preview2', 'sohranit', 'Сохранить')
                },
                {
                    block: 'button',
                    mix: [{
                        block: 'b-group-preview2',
                        elem: 'control',
                        elemMods: {
                            action: 'cancel'
                        }
                    }],
                    content: iget2('b-group-preview2', 'otmenit', 'Отменить')
                }
            ])
        );

        showNoOneBid && !tabIsArchive && !!archiveCount && (result = result.concat([
            {
                block: 'link',
                mods: {
                    pseudo: 'yes',
                    style: 'without-border'
                },
                mix: [{
                    block: 'b-group-preview2',
                    elem: 'control',
                    elemMods: {
                        action: 'go-archive'
                    }
                }],
                content: iget2('b-group-preview2', 'arhiv', 'Архив')
            },
            '&nbsp',
            {
                elem: 'archive-count',
                tag: 'span',
                content: '(' + archiveCount + ')'
            }
        ]));

        showNoOneBid && vmData.editable && result.push({
            block: 'button',
            mix: [{
                block: 'b-group-preview2',
                elem: 'control',
                elemMods: {
                    action: 'edit-group'
                }
            }],
            url: u.formatUrl({
                path: '/registered/main.pl',
                query: {
                    cmd: 'showCamp',
                    tab: 'all',
                    search_by: 'group',
                    search_banner: vmData.adgroupId,
                    cid: vmData.cid,
                    ulogin: u.consts('ulogin')
                }
            }),
            content: iget2('b-group-preview2', 'pereyti-k-gruppe', 'Перейти к группе')
        });

        return result;
    }),

    match(function() {
        return !this.ctx.vmData || (this.ctx.vmData.showOneBid ?
            (this.ctx.vmData.readonly || this.ctx.vmData.tabIsArchive) :
            this.ctx.vmData.readonly &&
                !this.ctx.vmData[this.ctx.vmData.tabIsArchive ? 'countNoArchiveBanners' : 'countArchiveBanners']);
    }).def()('')
);
