block('b-group-preview2').def()(function() {
    return applyCtx({
        block: 'popup',
        js: {
            directions: this.ctx.popupDirections || ['right-middle-left', 'top-left-right', 'bottom-left-right']
        },
        mix: [{
            block: 'b-group-preview2',
            mods: u._.extend(
                {
                    readonly: this.ctx.readonly ? 'yes' : '',
                    'media-type': this.ctx.mediaType
                },
                this.mods
            ),
            js: this.ctx.js
        }],

        mods: {
            'has-close': 'yes',
            'with-controls': 'yes',
            autoclosable: 'yes',
            adaptive: 'yes',
            'content-adaptive': 'yes'
        },
        content: [
            {
                elem: 'tail'
            },
            {
                elem: 'content',
                content: {
                    block: 'b-group-preview2',
                    elem: 'popup-wrapper',
                    content: [
                        {
                            block: 'b-group-preview2',
                            mods: this.mods,
                            elem: 'content',
                            bannerAimingAllowed: this.ctx.js.bannerAimingAllowed
                        },
                        {
                            block: 'b-group-preview2',
                            elem: 'spinner-wrapper',
                            content: {
                                block: 'spin',
                                js: true,
                                mix: [{
                                    block: 'b-group-preview2',
                                    elem: 'spinner'
                                }],
                                mods: {
                                    progress: 'no',
                                    theme: 'gray-48'
                                }
                            }
                        }
                    ]
                }
            }
        ]
    });
});

block('b-group-preview2').elem('content').content()(function() {
    var vmData = this.ctx.vmData;

    return [
        {
            block: 'b-group-preview2',
            elem: 'header',
            vmData: vmData
        },
        {
            block: 'b-group-preview2',
            elem: 'banners',
            vmData: vmData,
            bannerAimingAllowed: this.ctx.bannerAimingAllowed
        },
        {
            block: 'b-group-preview2',
            elem: 'footer',
            vmData: vmData
        }
    ];
});

block('b-group-preview2').elem('no-banners-msg').content()(function() {
    return [
        {
            block: 'b-group-preview2',
            elem: 'no-banners-header',
            content: iget2('b-group-preview2', 'no-banners-header', 'Пока нет объявлений'),
        },
        {
            block: 'b-group-preview2',
            elem: 'no-banners-text',
            content: iget2('b-group-preview2', 'no-banners-text', 'Вы можете добавить еще {avaliableBannersCount} объявлений в эту группу ', {
                avaliableBannersCount: u.consts('DEFAULT_CREATIVE_COUNT_LIMIT')
            }),
        }
    ]
});
