(function() {
    var confirm = BEM.DOM.blocks['b-confirm'],
        instance;

    BEM.DOM.decl({ block: 'b-group-preview2' }, {

        onSetMod: {

            js: function() {
                var params = this.params,
                    groupType = params.groupType,
                    groupId = params.groupId;

                this._campaignModel = this.params;

                BEM.blocks['b-metrika2'].params({
                    params: {
                        showCamp: {
                            'banner-preview': 'popup-show'
                        }
                    }
                });

                this._viewModel = BEM.MODEL.create({ name: 'b-group-preview2', id: params.uniqId }, {
                    generalBid: params.generalBid,
                    showOneBid: params.showOneBid,
                    readonly: params.readonly,
                    statusMetricaStop: params.statusMetricaStop,
                    campaignMediaType: params.campaignMediaType,
                    cid: params.cid
                });

                this._viewModel
                    .on('busyStatus', 'change', this._onBusyStatusChange, this)
                    .on('errorAlert', 'change', this._onError, this)
                    .on('readonly', 'change', this._onReadonlyChange, this)
                    .on('tab', 'change', this._setFilterTypeMod, this)
                    .on('shownBannersData', 'change', this._onChangeShownBannersData, this)
                    .on('hasChangedStatuses', 'change', this._changeStatusesBank, this)
                    .on('zero_banners_quantity', 'change', function(e, data) {
                        if (data.value) {
                            BEM.DOM.replace(
                                this.findElem('popup-wrapper'),
                                BEMHTML.apply({
                                    block: 'b-group-preview2',
                                    elem: 'no-banners-msg',
                                })
                            )
                        }
                    }, this);
                this._viewModel.init(groupId, groupType);

                this._getPopup().on('hide', this._onPopupHide, this);
            }
        },

         /**
         * Обработчик изменения данных набора баннеров
         * @private
         */
        _onChangeShownBannersData: function() {
            BEM.DOM.replace(this.findElem('content'), BEMHTML.apply({
                block: 'b-group-preview2',
                mods: { 'group-type': this.getMod('group-type') },
                elem: 'content',
                vmData: this._viewModel.toJSON(),
                bannerAimingAllowed: this.params.bannerAimingAllowed
            }));
        },

        /**
         * Обработчик поля которое означает, что статус хотя бы одного баннера был изменен
         * @param {jQuery.Event} e
         * @param {Object} data
         * @param {Boolean} data.value значение поля
         * @private
         */
        _changeStatusesBank: function(e, data) {
            this.findBlockOn(this.findElem('control', 'action', 'save'), 'button')
                .setMod('disabled', data.value ? '' : 'yes');
        },

        /**
         * Обработчик закрытия попапа
         * @private
         */
        _onPopupHide: function() {
            // задержка чтобы попап успел закрыться
            this.afterCurrentEvent(function() {
                this.destruct();
                instance = null;
            }, this);
        },

        /**
         * Обработчик состояния ошибки
         * @private
         */
        _onError: function() {
            confirm.alert(iget2('b-group-preview2', 'proizoshla-oshibka-zaprosa', 'Произошла ошибка запроса.'), this._getPopup());
        },

        /**
         * Открывает и закрывает попап.
         * @param {Object} owner
         * @private
         */
        _toggle: function(owner) {

            var popup = this._getPopup();

            if (popup.isShown() && owner && popup._owner[0] !== owner[0]) {
                popup
                    .un('hide', this._onPopupHide, this)
                    .show(owner)
                    .on('hide', this._onPopupHide, this);
            } else {
                popup.toggle(owner);
            }
        },

        /**
         * Сохраняет изменения и закрывает попап.
         * @private
         */
        _save: function() {
            this._viewModel.applyChangedShownStatuses(this._toggle.bind(this));
        },

        /**
         * Обновляет визуальное состояние загрузки
         * @param {jQuery.Event} e
         * @param {Object} data
         * @param {Number} data.value состояние занятости view-модели
         * @private
         */
        _onBusyStatusChange: function(e, data) {
            this._updateSpinner(!!data.value);
        },

        /**
         * Обработчик на изменение поля readonly
         * Может поменяться только в случае если изначально модели группы не было и после ее создания и заполнения
         * выяснилось (до отрисовки внутренностей блока), что изменять группу нельзя - поэтому меняем только модификатор
         * @param {jQuery.Event} e
         * @param {Object} data
         * @private
         */
        _onReadonlyChange: function(e, data) {
            this.setMod('readonly', data.value ? 'yes' : '');
        },

        /**
         * Обновляет отображение спиннера.
         * @param {Number} isBusy - Специальное число показывающее кол-во активных действий,
         * если больше 0, то блокируем интерфейс.
         * @private
         */
        _updateSpinner: function(isBusy) {
            this.setMod('busy', isBusy ? 'yes' : '');

            this._getSpinner().setMod('progress', isBusy ? 'yes' : 'no');
        },

        /**
         * Обработчик клика по кнопке архивировать.
         * @param {String} bid - id баннера.
         * @private
         */
        _onArchiveClick: function(bid) {
            var mediaType;

            if (this._viewModel.isGeneralBanner(bid)) {
                mediaType = this._viewModel.getGroupModel().get('adgroup_type');

                confirm.open({
                    message: ({
                        performance: iget2('b-group-preview2', 'vy-deystvitelno-hotite-zaarhivirovat', 'Вы действительно хотите заархивировать основной баннер?'),
                        mcbanner: iget2('b-group-preview2', 'vy-deystvitelno-hotite-zaarhivirovat', 'Вы действительно хотите заархивировать основной баннер?')
                    })[mediaType] || iget2(
                        'b-group-preview2',
                        'vy-deystvitelno-hotite-zaarhivirovat-100',
                        'Вы действительно хотите заархивировать основное объявление?'
                    ),
                    onYes: function() {
                        this._viewModel.archiveBannerByIdWithRedirect(bid);
                    },
                    fromPopup: this._getPopup()
                }, this);
            } else {
                this._viewModel.archiveBannerById(bid);
            }
        },

        /**
         * Обработчик клика по кнопке разархивировать.
         * @param {String} bid - id баннера.
         * @private
         */
        _onUnArchiveClick: function(bid) {
            var mediaType;

            if (this._viewModel.isGeneralBanner(bid)) {
                mediaType = this._viewModel.getGroupModel().get('adgroup_type');

                confirm.open({
                    message: ({
                        performance: iget2('b-group-preview2', 'vy-deystvitelno-hotite-razarhivirovat', 'Вы действительно хотите разархивировать основной баннер?'),
                        mcbanner: iget2('b-group-preview2', 'vy-deystvitelno-hotite-razarhivirovat', 'Вы действительно хотите разархивировать основной баннер?')
                    })[mediaType] || iget2(
                        'b-group-preview2',
                        'vy-deystvitelno-hotite-razarhivirovat-101',
                        'Вы действительно хотите разархивировать основное объявление?'
                    ),
                    onYes: function() {
                        this._viewModel.unArchiveBannerByIdWithRedirect(bid);
                    },
                    fromPopup: this._getPopup()
                }, this);
            } else {
                this._viewModel.unArchiveBannerById(bid);
            }
        },

        /**
         * Обработчик клика по кнопке удалить.
         * @param {String} bid - id баннера.
         * @private
         */
        _onDeleteClick: function(bid) {
            var groupModel = this._viewModel.getGroupModel(),
                isLastBanner = groupModel.isLastBanner(),
                mediaType = groupModel.get('adgroup_type'),
                isGeneralBanner = this._viewModel.isGeneralBanner(bid);

            return confirm.open({
                message: isLastBanner ?
                    iget2('b-group-preview2', 'vy-deystvitelno-hotite-udalit', 'Вы действительно хотите удалить группу?') :
                    isGeneralBanner ?
                        ({
                            performance: iget2('b-group-preview2', 'vy-deystvitelno-hotite-udalit-102', 'Вы действительно хотите удалить основной баннер?'),
                            mcbanner: iget2('b-group-preview2', 'vy-deystvitelno-hotite-udalit-102', 'Вы действительно хотите удалить основной баннер?')
                        })[mediaType] ||
                            iget2('b-group-preview2', 'vy-deystvitelno-hotite-udalit-103', 'Вы действительно хотите удалить основное объявление?') :
                        ({
                            performance: iget2('b-group-preview2', 'vy-deystvitelno-hotite-udalit-104', 'Вы действительно хотите удалить баннер?'),
                            mcbanner: iget2('b-group-preview2', 'vy-deystvitelno-hotite-udalit-104', 'Вы действительно хотите удалить баннер?')
                        })[mediaType] ||
                            iget2('b-group-preview2', 'vy-deystvitelno-hotite-udalit-105', 'Вы действительно хотите удалить объявление?'),
                onYes: function() {
                    this._viewModel[isGeneralBanner ? 'deleteBannerByIdWithRedirect' : 'deleteBannerById'](bid);
                },
                fromPopup: this._getPopup()
            }, this);
        },

        /**
         * Обработчик клика по кнопке разархивировать все.
         * @private
         */
        _onUnArchiveAllClick: function() {
            this._viewModel.unArchiveAll();
        },

        /**
         * Достает id баннера из события клика на кнопку.
         * @param {jQuery} domElem - DOM-нода элемента `control` с bid в параметрах
         * @returns {String} - id баннера
         * @private
         */
        _parseBid: function(domElem) {
            return this.elemParams(domElem).bid;
        },

        /**
         * Обработчик изменения тумблера показа баннера.
         * @param {jQuery.Event} e Событие
         * @param {Object} data Объект события
         * @private
         */
        _onTumblerChange: function(e, data) {
            var bid = this._parseBid(e.block.domElem),
                isShown = data.checked;

            this._viewModel.commitShownStatus(isShown, bid);

            this.setMod(this.findElem('banner-item', 'bid', bid), 'off', isShown ? '' : 'yes');
        },

        /**
         * Устанавливает модификатор в зависимости от текущего фильтра по типу.
         * @param {jQuery.Event} e
         * @param {Object} data
         * @private
         */
        _setFilterTypeMod: function(e, data) {
            this.setMod('type-filter', u.beminize(data.value || ''));
        },

        destruct: function() {
            this._viewModel
                .un('busyStatus', 'change', this._onBusyStatusChange, this)
                .un('errorAlert', 'change', this._onError, this)
                .un('readonly', 'change', this._onReadonlyChange, this)
                .un('tab', 'change', this._setFilterTypeMod, this)
                .un('shownBannersData', 'change', this._onChangeShownBannersData, this)
                .un('hasChangedStatuses', 'change', this._changeStatusesBank, this);

            this._getPopup().un('hide', this._onPopupHide, this);

            this._viewModel.destruct();

            //cyn@TODO: разобраться почему не вызывается destruct у вложенных блоков
            BEM.DOM.destruct(true, this.domElem, true);

            return this.__base.apply(this, arguments);
        },

        /**
         * Обработчик клика по ссылкам
         * @param {jQuery.Event} e
         * @private
         */
        _onControlClick: function(e) {
            var domElem = e.block.domElem;

            if (!this.findElem('control').is(domElem)) return;

            var action = this.getMod(domElem, 'action');

            BEM.blocks['b-metrika2'].params({
                params: {
                    showCamp: {
                        'banner-preview': action
                    }
                }
            });

            switch (action) {
                case 'go-archive':
                    return this._viewModel.set('tabHash', { type: 'archive' });
                case 'go-no-archive':
                    return this._viewModel.set('tabHash', null);
                case 'save':
                    return this._save();
                case 'cancel':
                    return this._toggle();
                case 'archive':
                    return this._onArchiveClick(this._parseBid(domElem));
                case 'unarchive':
                    return this._onUnArchiveClick(this._parseBid(domElem));
                case 'unarchive-all':
                    return this._onUnArchiveAllClick();
                case 'delete':
                    return this._onDeleteClick(this._parseBid(domElem));
            }
        },

        /**
         * Возвращает экземпляр блока попап
         * @returns {BEM.DOM}
         * @private
         */
        _getPopup: function() {
            return this._popup || (this._popup = this.findBlockOn('popup'));
        },

        /**
         * Возвращает экземпляр блока спиннер
         * @returns {BEM.DOM}
         * @private
         */
        _getSpinner: function() {
            return this._spinner || (this._spinner = this.findBlockInside('spin'));
        },

        /**
         * Обработчик клика по кнопке показа всех форматов
         * @param {Event} e - событие
         * @private
         */
        _onBannerAllFormatsButtonClick: function(e) {
            var previewBlock = this.findBlockInside('b-banner-preview2'),
                bannerData = previewBlock.getDM('banner').toJSON(),
                bannerPcodeData = u['b-banner-preview2'].getDataToPcode(previewBlock),
                campaignModel = this._viewModel.getCampaignModel();

            e.block.showBannerAllFormats(
                {
                    parent: this._getPopup(),
                    clientId: this.params.clientId,
                    cid: campaignModel.get('cid')
                },
                {
                    mediaType: this._viewModel.get('adgroupType'),
                    bannerData: bannerData,
                    bannerPcodeData: bannerPcodeData
                }
            );
        }
    }, {

        live: function() {
            this
                .liveInitOnBlockInsideEvent('change', 'b-banner-preview-filter2', function(e, data) {
                    this._viewModel.set('tabHash', data.value);
                })
                .liveInitOnBlockInsideEvent(
                    'banner-all-formats-button:click',
                    'b-banner-preview-filter2',
                    function(e, data) {
                        this._onBannerAllFormatsButtonClick(e, data);
                    }
                )
                .liveInitOnBlockInsideEvent('click', 'link', function(e, data) {
                    this._onControlClick(e, data);
                })
                .liveInitOnBlockInsideEvent('click', 'button', function(e, data) {
                    this._onControlClick(e, data);
                })
                .liveInitOnBlockInsideEvent('change', 'tumbler', function(e, data) {
                    this._onTumblerChange(e, data);
                });
        },

        /**
         * Открывает попап группы
         * @param {Object} options
         * @param {String} options.clientId Идентификатор клиента
         * @param {String} options.groupId Идентификатор группы
         * @param {String} options.campaignMediaType Тип кампании
         * @param {String} options.groupType Тип группы
         * @param {String} [options.showOneBid] bid баннера, который нужно показывать в одиночку в попапе групп
         * @param {String} [options.generalBid] bid баннера, при изменении которого нужен редирект,
         * @param {Boolean} options.bannerAimingAllowed разрешено ли нацеливание на баннер
         * для обновления этого баннера на странице вне попапа
         * @param {Boolean} options.readonly Если `true` - то без кнопок действия
         * @param {String[]|String} options.popupDirections Направления раскрытия попапа
         * @param {jQuery} options.owner Элемент к которому должна указывать стрелка попапа
         */
        showGroupPopup: function(options) {
            var uniqId = options.groupId + (options.showOneBid ? '-' + options.showOneBid : '');

            if (!instance || instance.params.uniqId !== uniqId) {
                instance && instance.destruct();

                instance = $(BEMHTML.apply({
                    block: 'b-group-preview2',
                    mods: { 'group-type': u.beminize(options.groupType) },
                    js: {
                        uniqId: uniqId,
                        clientId: options.clientId,
                        campaignMediaType: options.campaignMediaType,
                        groupId: options.groupId,
                        groupType: options.groupType,
                        cpmGroupType: options.cpmGroupType,
                        showOneBid: options.showOneBid,
                        generalBid: options.generalBid,
                        readonly: options.readonly,
                        statusMetricaStop: options.statusMetricaStop,
                        bannerAimingAllowed: options.bannerAimingAllowed,
                    },
                    readonly: options.readonly,
                    popupDirections: options.popupDirections,
                    mediaType: options.groupType
                })).bem('b-group-preview2');
            }

            instance._toggle(options.owner);
        }

    });
}());
