block('b-group-regions')(
    def()(function() {
        return applyNext({
            'mods.warning': this.ctx.exceptions && this.ctx.exceptions.all ? 'visible' : 'hidden'
        });
    }),

    content()(function() {
        var TRUNCATE_LENGTH = 50,
            ctx = this.ctx,
            names = ctx.geoNames || '',
            needTruncate = names.length > TRUNCATE_LENGTH,
            truncated;

        if (needTruncate) {
            truncated = u.hellipCut(names, TRUNCATE_LENGTH);
        }

        return [
            {
                elem: 'names',
                truncate: needTruncate,
                fullNames: names,
                displayNames: needTruncate ? truncated : names,
                count: ctx.count
            }

        ];
    }),

    elem('names').content()(
        match(function() { return !this.ctx.truncate; })(function() {
            return this.ctx.displayNames;
        }),

        match(function() { return this.ctx.truncate; })(function() {

            return [
                this.ctx.displayNames,
                '&nbsp;&ndash; ',
                iget2('b-group-regions', 'vsego', 'всего'),
                '&nbsp;',
                {
                    block: 'b-group-regions',
                    elem: 'names-popup',
                    fullNames: this.ctx.fullNames,
                    switcherText: u.pluralize([iget2('b-group-regions', 'region', 'регион'), iget2('b-group-regions', 'regiona', 'региона'), iget2('b-group-regions', 'regionov', 'регионов')], this.ctx.count, '&nbsp;')
                }
            ];
        }))
);
