block('b-group-retargeting-condition')(

    def()(function() {
        var tagsToReplace = {
            '&': '&amp;',
            '<': '&lt;',
            '>': '&gt;'
        };

        this.ctx.condition.condition_name_escape = u.hellipCut(
            this.ctx.condition.condition_name.replace(/[&<>]/g, function(tag) { return tagsToReplace[tag] || tag }),
            50
        );

        return applyNext();
    }),

    js()(function() {
        return {
            conditionId: this.ctx.condition.ret_cond_id,
            modelParams: 'm-retargeting-condition'
        };
    }),

    content()(function() {
        return [
            !!this.ctx.num && {
                elem: 'num',
                tag: 'span',
                content: this.ctx.num + '.&nbsp;'
            },
            {
                block: 'link',
                mix: [
                    {
                        block: 'b-group-retargeting-condition',
                        elem: 'name'
                    }
                ],
                mods: {
                    pseudo: 'yes',
                    theme: 'without-border',
                    disabled: this.mods.disabled || this.ctx.deleteOnlyMode
                },
                content: {
                    block: 'b-group-retargeting-condition',
                    elem: 'model-field',
                    js: {
                        name: 'condition_name_escape',
                        type: 'inline'
                    },
                    tag: 'span',
                    content: this.ctx.condition.condition_name_escape
                }
            },
            this.ctx.condition.is_negative && { elem: 'rates-adjustment-only-hint' },
            { elem: 'remove' }
        ];
    }),

    elem('remove').replace()(
        (function() {
            return {
                block: 'link',
                mix: [{
                    block: 'b-group-retargeting-condition',
                    elem: 'remove'
                }],
                mods: {
                    pseudo: 'yes',
                    theme: 'without-border',
                    disabled: this.mods.disabled
                },
                content: {
                    block: 'b-icon',
                    mods: {
                        'size-13': 'grey-cross'
                    }
                }
            };
        }),

        mod('without-remove', 'yes')('')
    ),

    elem('rates-adjustment-only-hint').replace()(function() {
        return {
            block: 'b-adjustment-rates-condition-hint',
            mix: { block: 'b-group-retargeting-condition', elem: 'rates-condition-hint' },
            icon: { 'size-13': 'info', theme: 'light' }
        };
    })
);
