BEM.DOM.decl({ block: 'b-group-retargeting-condition', baseBlock: 'i-glue' }, {

    onSetMod: {

        js: function() {
            var conditionId = this.params.conditionId;

            this.model = BEM.MODEL.getOrCreate({
                name: 'm-retargeting-condition',
                id: conditionId
            });

            // От i-glue нам не нужен инит модели, только поля
            // Таким образом мы привяжемся к существующей модели
            this._initFields();

            u.graspSelf.call(this, {
                editLink: 'link on name'
            });

            this.removeLink = this.findBlockOn('remove', 'link');

            this.editLink.on('click', function() {
                this.trigger('edit', { conditionId: conditionId, target: this.elem('name') });
            }, this);

            this.removeLink && this.removeLink.on('click', function() {
                this.afterCurrentEvent(function() {
                    this.trigger('remove', { conditionId: conditionId });
                });
            }, this);
        }

    }

});
