block('b-group-retargeting2')(
    js()(function() {
        return {
            conditions: this.ctx.conditions,
            selectedConditions: this.ctx.selectedConditions,
            conditionsLimit: this.ctx.conditionsLimit
        };
    }),

    content()(function() {

        return [
            { elem: 'buttons' },
            { elem: 'spin' },
            { elem: 'conditions-list', selectedConditions: this.ctx.selectedConditions, deleteOnlyMode: false }
        ];
    }),

    elem('conditions-list').content()(function() {
        var selectedConditions = this.ctx.selectedConditions || [];

        if (selectedConditions.length) {
            return selectedConditions.map(function(condition, n) {
                return {
                    block: 'b-group-retargeting-condition',
                    mods: {
                        inline: this.mods.inline,
                        goals: !condition.is_accessible ? 'unavailable' : '',
                        last: selectedConditions.length - 1 == n ? 'yes' : '',
                        disabled: this.mods.disabled
                    },
                    mix: {
                        block: 'b-group-retargeting2',
                        elem: 'conditions-list'
                    },
                    deleteOnlyMode: this.ctx.deleteOnlyMode,
                    condition: condition,
                    num: n + 1
                }
            }, this);
        }

        return {
            block: 'b-group-retargeting2',
            elem: 'empty-conditions',
            content: iget2('b-group-retargeting2', 'ne-zadany', 'Не заданы')
        };
    }),

    elem('spin').replace()(function() {
        return {
            block: 'spin',
            mix: { block: 'b-group-retargeting2', elem: 'spin' },
            js: true,
            mods: { theme: 'gray-16' }
        };
    }),

    elem('buttons').content()(function() {
        return [
            {
                block: 'button',
                mods: { theme: 'normal', size: 's', disabled: this.mods.disabled },
                mix: {
                    block: 'b-group-retargeting2',
                    elem: 'switcher',
                    elemMods: { type: 'add' }
                },
                content: iget2('b-group-retargeting2', 'dobavit', 'Добавить')
            },
            {
                block: 'button',
                mods: { theme: 'normal', size: 's', disabled: this.mods.disabled },
                mix: {
                    block: 'b-group-retargeting2',
                    elem: 'switcher',
                    elemMods: { type: 'edit' }
                },
                content: iget2('b-group-retargeting2', 'izmenit', 'Изменить')
            }
        ];
    })
);
