BEM.DOM.decl('b-group-retargeting2', {

    onSetMod: {
        js: function() {
            this._selectedConditions = this.params.selectedConditions || [];
            this._conditions = this.params.conditions;

            u.graspSelf.call(this, {
                _conditionList: 'conditions-list',
                _spin: 'spin on spin',
                _switcher: '? button on switcher'
            });
        },

        loading: function(modName, modVal) {
            this._spin.toggleMod('progress', 'yes', '', !!modVal);

            if (this._switcher) {
                this._switcher.toggleMod('disabled', 'yes', '', !!modVal);
            }
        }
    },

    /**
     * Инициализирует блок
     * @param {Object} params - объект с параметрами
     */
    initialize: function(params) {
        this._parentPopup = params.parentPopup;
    },

    /**
     * Открывает окно редактирования условия ретаргетинга
     * @param {{ conditionId, target }} data
     */
    editCondition: function(data) {
        BEM.DOM.blocks['b-retargeting-condition-edit-popup'].createInstance(
            {
                conditionId: data.conditionId,
                showBtnSaveAsNew: false,
                parentPopup: this._parentPopup
            })
            .on('changed', function(e, condition) {
                var conditionConv = u['b-retargetings-data'].mapResponseConditionToModel(condition),
                    model = BEM.MODEL.getOne({ name: 'm-retargeting-condition', id: condition.id });

                // а здесь обновляем данные, которые хранит этот блок
                this._conditions.forEach(function(cond) {
                    if (cond.ret_cond_id == conditionConv.ret_cond_id) {
                        u._.extend(cond, conditionConv);
                    }
                });

                model && model.update(conditionConv);
            }, this);
    },

    /**
     * Удалить условие ретаргетинга
     * @param {Number} conditionId id условия ретаргетинга
     */
    removeCondition: function(conditionId) {
        var conditions = this._selectedConditions,
            pos = -1;

        conditions.some(function(item, i) {
            return item.ret_cond_id == conditionId && (pos = i) + 1;
        });

        pos != -1 && conditions.splice(pos, 1);

        this._onConditionsUpdate();
    },

    /**
     * Отрисовать список условий ретаргетинга
     */
    renderConditions: function(conditions) {
        var conditionsIds = conditions || this._selectedConditions;

        this.setMod('type', conditionsIds.length ? 'edit' : 'add');

        BEM.DOM.update(
            this._conditionList,
            BEMHTML.apply(conditionsIds.length ?
                conditionsIds.map(function(cond, n) {
                    var condition = BEM.MODEL.getOrCreate({
                        name: 'm-retargeting-condition',
                        id: cond.ret_cond_id
                    }).toJSON();

                    return {
                        block: 'b-group-retargeting-condition',
                        mods: {
                            goals: condition.is_accessible ? undefined : 'unavailable',
                            inline: this.getMod('inline')
                        },
                        condition: condition,
                        num: n + 1
                    };
                }, this) :
                { block: 'b-group-retargeting2', elem: 'empty-conditions', content: iget2('b-group-retargeting2', 'ne-zadany', 'Не заданы') }));
    },

    /**
     * Показывает попап редактирования
     * @private
     */
    _openEditPopup: function() {
        this.toggleMod('loading', 'yes');

        this._popup = BEM.DOM.blocks['b-modal-popup-decorator'].create2(null, { hasClose: true, bodyScroll: false }, $);

        if (this._parentPopup) {
            this._popup
                .getPopup()
                .setParent(this._parentPopup);
        }

        this._popup
            .on('close-blocked', function() {
                BEM.blocks['b-confirm'].open({
                    message: iget2('b-group-retargeting2', 'izmeneniya-ne-budut-sohraneny', 'Изменения не будут сохранены. Продолжить?'),
                    onYes: function() {
                        this._popup.hide({ force: true });
                    }.bind(this)
                });
            }, this)
            .on('close', function() {
                this._retargetingController.destruct();
                this._popup.destruct();
            }, this);

        // получаем список доменов для условий ретаргетинга
        u['retargeting-dataprovider'].getGoalList()
            .then(
                function(goals) {
                    goals = u['b-retargetings-data'].formatGoalList(goals);

                    this._addConditionAdditionalInfo(goals);

                    this._popup.setPopupContent({
                        block: 'b-edit-retargeting',
                        singleChoice: !!(this.params.conditionsLimit && this.params.conditionsLimit < 2),
                        conditions: this._conditions,
                        selectedConditions: this._selectedConditions
                    })
                        .on('edit:completed', this._onEditRetargetingCompleted, this)
                        .on('added-condition', function(e, data) {
                            this._conditions.push(data);
                        }, this)
                        .on('updated-condition', function(e, condition) {
                            var model = BEM.MODEL.getOne({
                                name: 'm-retargeting-condition',
                                id: condition.ret_cond_id
                            });
                            this._conditions.forEach(function(cond) {
                                if (cond.ret_cond_id == condition.ret_cond_id) {
                                    u._.extend(cond, condition);
                                }
                            });
                            model && model.update(condition);
                        }, this);

                    this._popup.show();
                    this._onEditPopupOpen();

                    this.delMod('loading');
                }.bind(this),
                function() {
                    BEM.blocks['b-confirm'].alert(iget2('b-group-retargeting2', 'oshibka-obrashcheniya-k-metrike', 'Ошибка обращения к Метрике'));
                }
            );
    },

    /**
     * Выполняет необходимые операции при изменении списка выбранных условий ретаргетинга
     * @private
     */
    _onConditionsUpdate: function() {
        this.renderConditions();

        this.trigger('conditions:update', { conditions: this._selectedConditions.slice() });
    },

    /**
     * Добавляет к каждому условию ретаргетинга информацию о его доменах и наличии гео-сегментов
     * @param {Object} goalsData информация о целях условий ретаргетинга
     * @private
     */
    _addConditionAdditionalInfo: function(goalsData) {
        this._conditions.forEach(function(condition) {
            condition.domains = u['b-retargetings-data'].getConditionDomainsList(condition, goalsData);
            condition.hasGeoSegement = u['b-retargetings-data'].isConditionWithGeoSegment(condition, goalsData);
        });
    },

    /**
     * Инициализирует попап выбора условий ретаргетинга
     * @private
     */
    _onEditPopupOpen: function() {
        this._retargetingController = BEM.create('i-retargeting-controller', {
            parentPopup: this._popup.getPopup(),
            conditionsListBlock: this._popup.findBlockInside('b-retargeting-conditions-list')
        });

        this._retargetingController.on('deleteConditionCompleted', this._onDeleteConditionCompleted, this);
    },

    /**
     * Обработчик события сохранения выбора условий ретаргетинга
     * @param {Event} event
     * @param {Object} eventData
     * @param {Array} eventData.conditions список выбранных условий
     * @private
     */
    _onEditRetargetingCompleted: function(event, eventData) {
        this._selectedConditions = eventData.conditions;

        this._onConditionsUpdate();

        // DIRECT-59123: отмена закрывает попапы с force
        this._popup.hide({ force: eventData.force });
    },

    /**
     * Обработчик события при удалении одного из условий ретаргетинга
     * @param {Event} event
     * @param {Object} eventData
     * @param {Array} eventData.conditionId идентификатор условия ретаргетинга
     * @private
     */
    _onDeleteConditionCompleted: function(event, eventData) {
        var modelToDelete,
            conditionIdToDelete = eventData.conditionId;

        if (eventData.error) {
            BEM.blocks['b-confirm'].alert(eventData.error);

            return;
        }

        // удаляем условие из выбранных условий и списка всех условий
        this.removeCondition(conditionIdToDelete);
        this._conditions = this._conditions.filter(function(condition) {
            return condition.ret_cond_id !== conditionIdToDelete;
        });

        // удаляем модель соответствующую условию
        modelToDelete = BEM.MODEL.getOne({ name: 'm-retargeting-condition', id: conditionIdToDelete });
        modelToDelete && modelToDelete.destruct();
    }
}, {
    live: function() {
        this
            .liveBindTo('switcher', 'click', function(e) {
                this._openEditPopup();
            })
            .liveInitOnBlockInsideEvent('remove', 'b-group-retargeting-condition', function(e, data) {
                this.removeCondition(data.conditionId);
            })
            .liveInitOnBlockInsideEvent('edit', 'b-group-retargeting-condition', function(e, data) {
                this.editCondition(data);
            });

        return false;
    }
});
