/**
 * modelParams {Object} - параметры модели кампании
 * selectedLength {Number} - число групп, выбранных на редактирование
 */
block('b-group-tags-groupedit')(

    js()(function() {
        return { modelParams: this.ctx.modelParams }
    }),

    content()(function() {
        return {
            elem: 'form',
            selectedLength: this.ctx.selectedLength,
            useBanner: this.ctx.useBanner,
            mixBlock: this.ctx.mixBlock
        }
    }),

    elem('form').content()(function() {
        var ctx = this.ctx,
            mixBlock = ctx.mixBlock,
            selectedLength = ctx.selectedLength,
            useBanner = ctx.useBanner;

        return [
            {
                block: 'b-group-tags-groupedit',
                elem: 'header',
                mix: { block: mixBlock, elem: 'header' },
                useBanner: useBanner
            },
            selectedLength > 1 && {
                block: 'b-group-tags-groupedit',
                elem: 'sub-header',
                mix: [
                    { block: mixBlock, elem: 'note' },
                    { block: mixBlock, elem: 'bordered' }
                ],
                content: ctx.useBanner ?
                    iget2('b-group-tags-groupedit', 'vybrano-bannerov-s', 'Выбрано баннеров: {foo}', {
                        foo: selectedLength
                    }) :
                    iget2('b-group-tags-groupedit', 'vybrano-obyavleniy-s', 'Выбрано объявлений: {foo}', {
                        foo: selectedLength
                    })
            },
            {
                block: 'b-group-tags-groupedit',
                elem: 'checkbox-container-wrapper',
                mix: [
                    { block: mixBlock, elem: 'row' },
                    { block: mixBlock, elem: 'row-first' }
                ],
                content: {
                    block: 'b-group-tags-groupedit',
                    elem: 'checkbox-container'
                }
            },
            {
                block: 'b-group-tags-groupedit',
                elem: 'new-tags',
                mix: [
                    { block: mixBlock, elem: 'row' },
                    { block: mixBlock, elem: 'row-last' }
                ]
            },
            {
                block: 'b-group-tags-groupedit',
                elem: 'errors',
                mix: { block: mixBlock, elem: 'row-errors' }
            },
            {
                block: 'b-group-tags-groupedit',
                elem: 'footer',
                mix: { block: mixBlock, elem: 'footer' },
                content: [
                    {
                        block: 'button',
                        mods: { theme: 'action' },
                        mix: [
                            { block: 'b-group-tags-groupedit', elem: 'submit' },
                            { block: mixBlock, elem: 'footer-button' }
                        ],
                        content: iget2('b-group-tags-groupedit', 'sohranit', 'Сохранить')
                    },
                    {
                        block: 'button',
                        mix: [
                            { block: 'b-group-tags-groupedit', elem: 'cancel' },
                            { block: mixBlock, elem: 'footer-button' }
                        ],
                        content: iget2('b-group-tags-groupedit', 'otmena', 'Отмена')
                    }
                ]
            }
        ];
    }),

    elem('new-tags').content()(function() {
        return {
            block: 'input',
            placeholder: iget2('b-group-tags-groupedit', 'novye-metki-cherez-zapyatuyu', 'Новые метки (через запятую)'),
            content: [
                { elem: 'control' }
            ]
        };
    }),

    elem('header').content()(function() {
        return this.ctx.useBanner ?
            iget2('b-group-tags-groupedit', 'obshchie-metki-dlya-bannerov', 'Общие метки для баннеров') :
            iget2('b-group-tags-groupedit', 'obshchie-metki-dlya-obyavleniy', 'Общие метки для объявлений');
    }),

    elem('checkbox-label').tag()('label')
);
