//@todo: попробовать реализовать i-outboard-controls
(function($) {
    var getter = BEM.blocks['i-utils'].getter,
        endpointUrl = '/registered/main.pl',
        confirm = BEM.blocks['b-confirm'];

    BEM.DOM.decl('b-group-tags-groupedit', {
        onSetMod: {
            js: function() {
                this.request = BEM.create('i-request_type_ajax', {
                    url: endpointUrl,
                    cache: false,
                    dataType: 'json',
                    type: 'POST'
                });

                BEM.blocks['i-utils'].graspSelf.call(this, {
                    newTagsInput: 'input inside new-tags',  //todo обработать enter
                    errors: 'errors',
                    checkboxContainer: 'checkbox-container',
                    submit: 'button on submit',
                    cancel: 'button on cancel',
                    popup: 'popup outside'
                });

                this.campaign = BEM.MODEL.getOne(this.params.modelParams);
                this.groups = this.campaign.getSelectedGroups();

                this.popup.on('show', this.onShow, this);

                this.submit.on('click', this.onAccept, this);

                this.cancel.on('click', function() {
                    this.groups.forEach(getter('rollback'));
                    this.popup.hide();
                }, this);

                this.newTagsInput
                    .on('change', function() {
                        this.validateTags(this.newTagsInput.val());
                    }, this);

                this.bindTo(this.newTagsInput.elem('control'), 'keypress', function(e) {
                    if (this.validateTags(this.newTagsInput.val()) && e.which == 13) {
                        this.onAccept();
                    }
                });

                this.on('validateTags', function(e, errorString) {
                    this.trigger('state', { canSave: !errorString.length });
                    this.elem('errors').html(errorString);
                }, this);

                this.on('state', function(e, data) {
                    this.submit.setMod('disabled', data.canSave ? '' : 'yes');
                });

                BEM.blocks.checkbox.on('change', function(e) {
                    var popupContent = e.block.findBlockOutside('b-group-tags-groupedit');

                    popupContent && popupContent._onTagCheckboxChange(e.block);
                });
            },
            state: {
                done: function() {
                    this.popup.hide();
                },
                '*': function(modName, modVal) {
                    var disabled = {
                        loading: 'yes',
                        done: ''
                    }[modVal];

                    this.submit.setMod('disabled', disabled);
                    this.newTagsInput.setMod('disabled', disabled);
                }
            }
        },

        destruct: function() {
            this.popup.un('show', this.onShow, this);
            this.__base.apply(this, arguments);
        },

        getCommonTags: function() {
            var groupsCount = this.groups.length,
                tagsHash = {},
                tagsIdsHash = {};

            this.groups.forEach(function(banner) {
                banner.get('tags', 'raw').forEach(function(tag) {
                    var tagId = tag.get('id');

                    tagsHash[tagId] = tag;

                    if (!tagsIdsHash[tagId]) {
                        tagsIdsHash[tagId] = 0;
                    }
                    tagsIdsHash[tagId] += 1;
                });
            }, {});

            return Object.keys(tagsIdsHash)
                .filter(function(key) {
                    return tagsIdsHash[key] == groupsCount;
                })
                .map(function(id) {
                    return tagsHash[id];
                });
        },

        onAccept: function() {
            this.groups.forEach(function(banner) {
                banner.fields.tags.rollback();
            });
            //@todo: оптимальный алгоритм
            setTimeout(function() { //todo: убрать таймаут, когда исправится ошибка в model-list
                this.findBlocksInside('checkbox', 'checkbox').forEach(function(el) {
                    var tagId = el.getMod('tag-id'),
                        hasTag = function(banner) {
                            return banner.get('tags').where({ id: tagId }).length;
                        };

                    if (el.isChecked()) {
                        var tag = {
                            id: tagId,
                            value: this.campaign.get('tags', 'raw').filter(function(cTag) {
                                return cTag.get('id') === tagId;
                            })[0].get('value')
                        };

                        this.groups.forEach(function(banner) {
                            if (!banner.get('tags', 'raw').filter(function(btag) {
                                return btag.get('id') === tag.id;
                            }).length) {
                                banner.get('tags').add(tag);
                            }
                        });
                    } else if (this.groups.every(hasTag)) {
                        this.groups.forEach(function(banner) {
                            banner.get('tags').remove(banner.get('tags', 'raw').filter(function(tag) {
                                return tag.get('id') === tagId;
                            })[0].id);
                        });
                    }
                }, this);

                this.performRequest({
                    adgroup_ids: this.groups.map(getter('get', 'adgroup_id')),
                    cid: this.campaign.get('cid')
                });
            }.bind(this), 50);

            BEM.blocks['b-metrika2'].params({
                params: {
                    showCamp: {
                        'add-or-create-tag': true
                    }
                }
            });
        },

        onShow: function() {
            this.groups.forEach(getter('fix'));
            this.renderCheckboxes();
            this.newTagsInput.val('');
            this.validateTags('');
        },

        performRequest: function(data) {
            var groups = this.groups,
                campaign = this.campaign,
                campTags = campaign.get('tags'),
                newTags = this.extractTagsFromInput(this.newTagsInput.val()),
                tagsIds = this.getCommonTags().map(getter('get', 'id')),
                ajaxData = {
                    cmd: 'saveAdGroupTags',
                    adgroup_ids: data.adgroup_ids.join(','),
                    cid: data.cid,
                    // флаг говорящий о том, что мы шлём этот ajax из формы создания/редактирования баннера
                    save_camp_tags_only: this.params.save_camp_tags_only,
                    ulogin: u.consts('ulogin')
                },
                _this = this,
                filteredNewTags = [],
                tagsToAdd = [],
                popup = this.popup;

            // удаляем из поля new_tags метки, которые отмечены в чекбоксах
            newTags.forEach(function(tag) {
                var cTag = campTags.where({ value: tag }).pop();
                if (!cTag) {
                    filteredNewTags.push(tag);
                } else {
                    tagsIds.push(cTag.get('id'));
                    tagsToAdd.push({
                        id: cTag.get('id'),
                        value: cTag.get('value')
                    })
                }
            });

            ajaxData.new_tags = filteredNewTags.join(',');
            ajaxData.tags_ids = tagsIds.join(',');

            this.setMod('state', 'loading');

            this.request.get(
                ajaxData,
                function(data) {
                    _this.setMod('state', 'done');
                    if (!data.error && !data.errors) {
                        if (data.new_tags_as_hash) {
                            // data.new_tags_as_hash - хэш вида {'<текст метки>': {tag_id: <id метки>}}
                            $.each(data.new_tags_as_hash, function(i, v) {
                                groups.concat(campaign).forEach(function(item) {
                                    item.get('tags').add({
                                        id: v.tag_id,
                                        value: i,
                                        uses_count: groups.length
                                    });
                                });
                            });

                            tagsToAdd.forEach(function(tagToAdd) {
                                groups.forEach(function(banner) {
                                    var tags = banner.get('tags');

                                    !tags.some(function(tag) {
                                        return tag.get('value') === tagToAdd.value;
                                    }) && tags.add(tagToAdd);
                                });
                            });
                        }
                        groups.forEach(function(banner) {
                            banner.fix();
                        });
                    } else {
                        confirm.alert(data.error || data.errors.join('\n'), popup);
                    }
                },
                function() {
                    _this.setMod('state', 'done');
                    confirm.alert(iget2('b-group-tags-groupedit', 'oshibka-soedineniya', 'Ошибка соединения!'), popup);
                });
        },

        extractTagsFromInput: function(input) {
            return input.replace(/\s*,\s*/g, ',') // удаляем пробелы вокруг запятых
                .replace(/,(?=,)/g, '') // оставляем только одну запятую подряд
                .replace(/^\s*/, '') // удаляем висячие пробелы в начале
                .replace(/\s*$/, '') // удаляем висячие пробелы
                .replace(/^,/, '') // удаляем висячую запятую в начале
                .replace(/,$/, '') // удаляем висячую запятую в конце
                .split(',');
        },

        validateTags: function(input) {
            var maxLength = u.consts('MAX_TAG_LENGTH'),
                maxCount = u.consts('MAX_TAGS_FOR_CAMPAIGN'),
                maxCountForBanner = u.consts('MAX_TAGS_FOR_BANNER'),
                singleTag = this.params.singleTag,
                //@todo singleTag
                tags = !singleTag ?
                    this.extractTagsFromInput(input).join(',') :
                    input.replace(/^\s*/g, '').replace(/\s*$/, ''),
                errors = [],
                errorsStr,
                checkedTagsIds = [],
                uncheckedTagsIds = [],
                campTagsValues = this.campaign.get('tags').map(getter('get', 'value')),
                campHasTag = function(tagValue) {
                    return campTagsValues.some(function(commonTagValue) {
                        return commonTagValue.toLowerCase() == tagValue.toLowerCase();
                    });
                };

            //@todo: оптимальный алгоритм
            this.findBlocksInside('checkbox', 'checkbox').forEach(function(el) {
                var tagId = el.getMod('tag-id');

                if (el.isChecked()) {
                    checkedTagsIds.push(tagId)
                } else if (this.groups.every(function(banner) {
                    return banner.get('tags').where({ id: tagId }).length;
                })) {
                    uncheckedTagsIds.push(tagId);
                }
            }, this);

            if (singleTag) {
                tags.length > maxLength && errors.push(iget2('b-group-tags-groupedit', 'prevyshena-dopustimaya-dlina', 'Превышена допустимая длина'));
                tags.indexOf(',') != -1 && errors.push(iget2('b-group-tags-groupedit', 'zapyataya-yavlyaetsya-nedopustimym-simvolom', 'Запятая является недопустимым символом'));
            } else {
                //@todo singleTag
                tags = tags == '' ? [] : tags.split(','); // если tags не пустая строка (иначе получим [""] с длиной 1)

                if (tags.filter(function(tag) { return !campHasTag(tag); }).length >
                    maxCount - this.campaign.get('tags', 'raw').length) {

                    errors.push(iget2('b-group-tags-groupedit', 'nelzya-sozdavat-bolshe-s', 'Нельзя создавать больше {foo} меток', {
                        foo: maxCount
                    }));
                }

                this.groups.forEach(function(banner) {
                    var tagsCount = banner.get('tags', 'raw').filter(function(tag) {
                        return checkedTagsIds.indexOf(tag.get('id')) == -1;
                    }).length;

                    if (tagsCount + tags.length + checkedTagsIds.length - uncheckedTagsIds.length > maxCountForBanner) {
                        errors.push(
                            iget2('b-group-tags-groupedit', 'nelzya-ustanavlivat-na-banner', 'Нельзя устанавливать на баннер больше {foo} меток', {
                                foo: maxCountForBanner
                            }) +
                                (this.groups.length > 1 ?
                                    ' ' + iget2('b-group-tags-groupedit', 'prevyshenie-u-obyavleniya-no', ' (превышение у объявления №{foo})', {
                                        foo: banner.get('adgroupId')
                                    }) :
                                    '')
                        );
                    }
                }, this);

                tags.map(function(el) {
                    if (el.length > maxLength)
                        errors.push(iget2('b-group-tags-groupedit', 's-prevyshaet-dopustimuyu-dlinu', '{foo} превышает допустимую длину', {
                            foo: '<pre>&laquo;' + BEM.blocks['i-utils'].escapeHTML(el) + '&raquo;</pre>'
                        }));
                });
            }

            errorsStr = $.map(errors, function(el) { return '<div>' + el + '</div>' }).join('') || '';

            this.trigger('validateTags', errorsStr);

            return !errorsStr.length;
        },

        /**
         * колбек изменения чекбокса,
         * добавляет/удаляет теги из модели баннера
         * @param {Object} el блок чекбокса
         * @private
         */
        _onTagCheckboxChange: function(el) {
            this.validateTags(this.newTagsInput.val());
        },

        //todo: мультиредактирование
        renderCheckboxes: function() {
            var campTags = this.campaign.get('tags', 'raw'),
                bannerTags = this.getCommonTags(),
                content = [],
                _this = this;

            campTags
                .sort(function(a, b) {
                    return a.get('value').toLowerCase() > b.get('value').toLowerCase() ? 1 : -1
                })
                .forEach(function(tag) {
                    var id = $.identify();
                    content.push(
                        {
                            block: 'b-group-tags-groupedit',
                            elem: 'checkbox',
                            content: [
                                {
                                    block: 'checkbox',
                                    mods: {
                                        checked: bannerTags.filter(function(bTag) {
                                            return tag.get('id') === bTag.get('id')
                                        } ).length ? 'yes' : '',
                                        'tag-id': tag.get('id')
                                    },
                                    mix: [{ block: 'b-group-tags-groupedit', elem: 'tag-checkbox' }],
                                    id: id,
                                    checkboxAttrs: { id: id }
                                },
                                {
                                    block: 'b-group-tags-groupedit',
                                    elem: 'checkbox-label',
                                    attrs: { for: id },
                                    content: tag.get('value')
                                }
                            ]
                        }
                    );
                });

            BEM.DOM.update(this.checkboxContainer, BEMHTML.apply(content),
                function() {
                    _this.dropElemCache('tag-checkbox');
                    _this.popup.show();
                }
            );
        }
    })
})(jQuery);
