block('b-group-tags-list').content()(function() {
    var url = this.ctx.tagUrl;

    return this.ctx.tags
        .sort(function(a, b) {
            return a.value.toLowerCase() > b.value.toLowerCase() ? 1 : -1;
        })
        .map(function(tag) {
            var isLink = !(this.ctx.currentTagId == tag.id || !url);

            return {
                tag: isLink ? 'a' : 'span',
                elem: 'link',
                content: u.escapeHTML(tag.value),
                attrs: isLink && {
                    href: url + '&tag=' + tag.id
                }
            }
        }, this);
});
