block('b-group-tags-popup-content')(

    js()(function() {
        return {
            adgroupIds: this.ctx.adgroupIds,
            modelParams: this.ctx.modelParams
        };
    }),

    content()(function() {
        return {
            elem: 'form',
            adgroupIds: this.ctx.adgroupIds,
            useBanner: this.ctx.useBanner
        };
    }),

    elem('form').content()(function() {
        var useBanner = this.ctx.useBanner;

        return [
            {
                block: 'b-group-tags-popup-content',
                elem: 'header',
                adgroupIds: this.ctx.adgroupIds,
                useBanner: this.ctx.useBanner
            },
            this.ctx.adgroupIds.length > 1 && {
                block: 'b-group-tags-popup-content',
                elem: 'sub-header',
                content: [useBanner ? iget2('b-group-tags-popup-content', 'vybrano-bannerov', 'Выбрано баннеров') : iget2('b-group-tags-popup-content', 'vybrano-obyavleniy', 'Выбрано объявлений'), ': ', this.ctx.adgroupIds.length]
            },
            {
                block: 'b-group-tags-popup-content',
                elem: 'checkbox-container-wrapper',
                content: {
                    block: 'b-group-tags-popup-content',
                    elem: 'checkbox-container'
                }
            },
            {
                block: 'b-group-tags-popup-content',
                elem: 'new-tags'
            },
            {
                block: 'b-group-tags-popup-content',
                elem: 'errors'
            }
        ];
    }),

    elem('new-tags').content()(function() {
        return {
            block: 'input',
            placeholder: iget2('b-group-tags-popup-content', 'novye-metki-cherez-zapyatuyu', 'Новые метки (через запятую)'),
            content: [
                {
                    elem: 'control'
                }
            ]
        };
    }),

    elem('checkbox-label').tag()('label'),

    elem('header').content()(function() {
        return this.ctx.useBanner ?
            u.pluralForms(iget2('b-group-tags-popup-content', 'metki-bannera-bannerov', 'Метки {баннера|баннеров}'), this.ctx.adgroupIds.length) :
            u.pluralForms(iget2('b-group-tags-popup-content', 'metki-obyavleniya-obyavleniy', 'Метки {объявления|объявлений}'), this.ctx.adgroupIds.length);
    })
);
