//@todo отрефакторить валидацию, сделать Command для сохранения, улучшить производительность(сейчас 200 меток шаблонизируются > 1.5 секунд)
(function($) {
    var getter = BEM.blocks['i-utils'].getter,
        endpointUrl = '/registered/main.pl';

    BEM.DOM.decl({ block: 'b-group-tags-popup-content', implements: 'i-outboard-controls' }, {
        onSetMod: {
            js: function() {
                this.request = BEM.create('i-request_type_ajax', {
                    url: endpointUrl,
                    cache: false,
                    dataType: 'json',
                    type: 'POST'
                });

                BEM.blocks['i-utils'].graspSelf.call(this, {
                    newTagsInput: 'input inside new-tags',
                    errors: 'errors',
                    checkboxContainer: 'checkbox-container'
                });
                this.campaign = BEM.MODEL.getOrCreate(this.params.modelParams);
                this.groups = this.campaign.getChildGroupsByIds(this.params.adgroupIds);
                this.outboard = this.findBlockOutside('b-outboard-controls');
                this._doBindings();
            },
            state: {
                done: function() {
                    this.trigger('state', { canSave: true });
                },
                '*': function(modName, modVal) {
                    var disabled = {
                        loading: 'yes',
                        done: ''
                    }[modVal];

                    this.newTagsInput.setMod('disabled', disabled);
                    this.trigger('state', { canSave: modVal == 'done' });
                }
            }
        },

        /**
         * Подписка на события поля ввода новых тегов, валидацию
         */
        _doBindings: function() {
            this.newTagsInput
                .on('change', function() {
                    this.validateTags(this.newTagsInput.val());
                }, this);

            this.bindTo(this.newTagsInput.elem('control'), 'keypress', function(e) {
                if (this.validateTags(this.newTagsInput.val()) && e.which == 13) {
                    this.outboard.accept(); //todo не обращаться к outboard
                }
            });

            this.on('validateTags', function(e, errorString) {
                this.trigger('state', { canSave: !errorString.length });
                this.elem('errors').html(errorString);
            }, this);
        },

        /**
         * Подготовка к показу. Если переданы adgroupIds баннеров, то будут заменены модели баннеров
         * вызывает фикс баннеров
         * отрисовывает дропдаун тегов
         * @param {Array} [adgroupIds]
         */
        prepareToShow: function(adgroupIds) {
            if (adgroupIds) {
                this.groups = this.campaign.getChildGroupsByIds(adgroupIds);

                this.groups.forEach(getter('fix'));
                this.renderCheckboxes();
                this.newTagsInput.val('');
                this.validateTags('');
            }
        },

        /**
         * При отмене изменений откатываем модель тегов
         */
        declineChange: function() {
            this.groups.forEach(function(group) {
                group.fields['tags'].rollback();
            });
        },

        /**
         * вызывает запрос на сервер для проверки и сохранения тегов
         */
        provideData: function() {
            this.performRequest({
                adgroup_ids: this.groups.map(function(group) {
                    return group.get('adgroup_id');
                }),
                cid: this.campaign.id
            });
            BEM.blocks['b-metrika2'] && BEM.blocks['b-metrika2'].params({
                params: {
                    showCamp: {
                        'add-or-create-tag': true
                    }
                }
            });
        },

        /**
         * возвращает общие теги редактируемых баннеров
         * @returns {String[]}
         */
        getCommonTags: function() {
            var groupsCount = this.groups.length,
                tagsHash = {},
                tagsIdsHash = {},
                campTagsIdsHash = this.campaign.get('tags').reduce(function(acc, next) {
                    acc[next.get('id')] = true;
                    return acc;
                }, {});

            this.groups.forEach(function(banner) {

                banner.get('tags', 'raw').forEach(function(tag) {
                    var tagId = tag.get('id');

                    tagsHash[tagId] = tag;

                    if (!tagsIdsHash[tagId]) {
                        tagsIdsHash[tagId] = 0;
                    }
                    tagsIdsHash[tagId] += 1;
                });
            }, {});

            return Object.keys(tagsIdsHash)
                .filter(function(key) {
                    return campTagsIdsHash[key] && tagsIdsHash[key] == groupsCount;
                })
                .map(function(id) {
                    return tagsHash[id];
                });
        },

        /**
         *  выполняет запрос на сервер для валидации и сохранения тегов баннеров
         *  @param {Object} data
         */
        performRequest: function(data) {
            var groups = this.groups,
                groupsLen = groups.length,
                campaign = this.campaign,
                campTags = campaign.get('tags'),
                newTags = this.extractTagsFromInput(this.newTagsInput.val()),
                tagsIds = this.getCommonTags().map(getter('get', 'id')),
                ajaxData = {
                    cmd: 'saveAdGroupTags',
                    adgroup_ids: data.adgroup_ids.join(',') || undefined,
                    cid: data.cid,
                    // флаг говорящий о том, что мы шлём этот ajax из формы создания/редактирования баннера
                    save_camp_tags_only: this.params.saveCampTagsOnly,
                    ulogin: u.consts('ulogin')
                },
                _this = this,
                filteredNewTags = [],
                tagsToAdd = [],
                //конструктор функции фильтра регистронезависимого сравнения тегов
                hasTag = function(tag) {
                    return function(item) {
                        return (item.get('value') || '').toLowerCase() === tag.toLowerCase();
                    }
                };

            // удаляем из поля new_tags метки, которые отмечены в чекбоксах
            newTags.forEach(function(tag) {
                var cTag = campTags.filter(hasTag(tag)).pop();

                if (!cTag) {
                    filteredNewTags.push(tag);
                } else {
                    if (tagsIds.indexOf(cTag.get('id')) == -1) {
                        tagsIds.push(cTag.get('id'));
                        tagsToAdd.push({
                            id: cTag.get('id'),
                            value: cTag.get('value')
                        });
                    }
                }
            });

            ajaxData.new_tags = filteredNewTags.join(',') || undefined;
            ajaxData.tags_ids = tagsIds.join(',') || undefined;

            this.setMod('state', 'loading');
            this.request.get(
                ajaxData,
                function(data) {
                    _this.setMod('state', 'done');

                    if (data.error || data.errors) {
                        BEM.blocks['b-confirm'].alert(data.error || data.errors.join('\n'));

                        return;
                    } else if (data.new_tags_as_hash) {
                        tagsToAdd.forEach(function(tag) {
                            groups.forEach(function(banner) {
                                var tags = banner.get('tags');
                                !tags.filter(hasTag(tag.value)).pop() && tags.add(tag);
                            });
                        });

                        // DIRECT-137236 обновление тегов в новой шапке
                        BEM.blocks['b-dna-header'].updateCampaignTags(_this.campaign.id);

                        // data.new_tags_as_hash - хэш вида {'<текст метки>': {tag_id: <id метки>}}
                        $.each(data.new_tags_as_hash, function(i, v) {
                            groups.concat(campaign).forEach(function(item) {
                                item.get('tags').add({
                                    id: v.tag_id,
                                    value: i,
                                    uses_count: groupsLen
                                });
                            });
                        });
                    }
                    groups.concat(campaign).forEach(getter('fix'));
                },
                function() {
                    _this.setMod('state', 'done');
                    BEM.blocks['b-confirm'].alert(iget2('b-group-tags-popup-content', 'oshibka-soedineniya', 'Ошибка соединения!'));
                });
        },

        /**
         * парсит строку на теги
         * @param {String} input
         * @returns {String[]}
         */
        extractTagsFromInput: function(input) {
            return input.replace(/\s*,\s*/g, ',') // удаляем пробелы вокруг запятых
                .replace(/,(?=,)/g, '') // оставляем только одну запятую подряд
                .replace(/^\s*/, '') // удаляем висячие пробелы в начале
                .replace(/\s*$/, '') // удаляем висячие пробелы
                .replace(/^,/, '') // удаляем висячую запятую в начале
                .replace(/,$/, '') // удаляем висячую запятую в конце
                .split(',');
        },

        /**
         * вызывает разбор строки на теги, валидирует теги
         * триггерит событие validateTags
         * @param {String} input
         * @returns {Boolean} результат валидации: true, если нет ошибок
         */
        validateTags: function(input) {
            var maxLength = CONSTS.MAX_TAG_LENGTH,
                maxCount = CONSTS.MAX_TAGS_FOR_CAMPAIGN,
                maxCountForBanner = CONSTS.MAX_TAGS_FOR_BANNER,
                tags = this.extractTagsFromInput(input).join(','),
                errors = [],
                errorsStr,
                campTagsValues = this.campaign.get('tags').map(getter('get', 'value')),
                campHasTag = function(tagValue) {
                    return campTagsValues.some(function(commonTagValue) {
                        return commonTagValue.toLowerCase() == tagValue.toLowerCase();
                    });
                };

            if (this.params.singleTag) {
                tags.length > maxLength && errors.push(iget2('b-group-tags-popup-content', 'prevyshena-dopustimaya-dlina', 'Превышена допустимая длина'));
                tags.indexOf(',') != -1 && errors.push(iget2('b-group-tags-popup-content', 'zapyataya-yavlyaetsya-nedopustimym-simvolom', 'Запятая является недопустимым символом'));
            } else {
                tags = tags == '' ? [] : tags.split(','); // если tags не пустая строка (иначе получим [""] с длиной 1)

                if (tags.filter(function(tag) { return !campHasTag(tag); }).length >
                    maxCount - this.campaign.get('tags', 'raw').length) {

                    errors.push(iget2('b-group-tags-popup-content', 'nelzya-sozdavat-bolshe-s', 'Нельзя создавать больше {foo} меток', {
                        foo: maxCount
                    }));
                }

                this.groups.forEach(function(banner) {
                    var tagsCount = banner.get('tags', 'raw').length;

                    if (tagsCount + tags.length > maxCountForBanner) {
                        errors.push(
                            iget2('b-group-tags-popup-content', 'nelzya-ustanavlivat-na-banner', 'Нельзя устанавливать на баннер больше {foo} меток', {
                                foo: maxCountForBanner
                            }) +
                                (this.groups.length > 1 ?
                                    ' ' + iget2('b-group-tags-popup-content', 'prevyshenie-u-obyavleniya-no', ' (превышение у объявления №{foo})', {
                                        foo: banner.get('adgroup_id')
                                    }) :
                                    '')
                        );
                    }
                }, this);

                tags.map(function(el) {
                    if (el.length > maxLength) {
                        errors.push(
                            iget2('b-group-tags-popup-content', 's-prevyshaet-dopustimuyu-dlinu', '{foo} превышает допустимую длину', {
                                foo: '<pre>&laquo;' + BEM.blocks['i-utils'].escapeHTML(el) + '&raquo;</pre>'
                            }));
                    }
                });
            }

            errorsStr = errors.map(function(el) { return '<div>' + el + '</div>' }).join('') || '';

            this.trigger('validateTags', errorsStr);

            return !errorsStr.length;
        },

        /**
         * отрисовывает чекбоксы тегов в дропдаун
         */
        renderCheckboxes: function() {
            var campTags = this.campaign.get('tags', 'raw'),
                bannerTags = this.getCommonTags(),
                content = [],
                _this = this,
                checked,
                id;

            campTags
                .sort(function(a, b) {
                    return a.get('value').toLowerCase() > b.get('value').toLowerCase() ? 1 : -1;
                })
                .forEach(function(tag) {
                    id = $.identify();

                    checked = bannerTags.some(function(bTag) { return tag.get('id') === bTag.get('id') }) ? 'yes' : '';

                    content.push(
                        {
                            block: 'b-group-tags-popup-content',
                            elem: 'checkbox',
                            content: [
                                {
                                    block: 'checkbox',
                                    mods: {
                                        checked: checked,
                                        'tag-id': tag.get('id')
                                    },
                                    mix: [{ block: 'b-group-tags-popup-content', elem: 'tag-checkbox' }],
                                    id: id,
                                    checkboxAttrs: { id: id }
                                },
                                {
                                    block: 'b-group-tags-popup-content',
                                    elem: 'checkbox-label',
                                    attrs: { for: id },
                                    content: tag.get('value')
                                }
                            ]
                        }
                    );
                });

            BEM.DOM.update(this.checkboxContainer, BEMHTML.apply(content),
                function() {
                    _this.dropElemCache('tag-checkbox');
                }
            );
        },

        /**
         * колбек изменения чекбокса,
         * добавляет/удаляет теги из модели баннера
         * @param {Object} el блок чекбокса
         * @private
         */
        _onTagCheckboxChange: function(el) {
            var tagId = el.getMod('tag-id'),
                isChecked = el.isChecked(),
                groups = this.groups,
                tags = {
                    add: function(tag) {
                        groups.forEach(function(banner) {
                            if (!banner.get('tags', 'raw').filter(function(btag) {
                                return btag.get('id') === tag.id;
                            }).length) {
                                banner.get('tags').add(tag);
                            }
                        });
                    },
                    remove: function(tagId) {
                        groups.forEach(function(banner) {
                            banner.get('tags').remove(banner.get('tags', 'raw').filter(function(tag) {
                                return tag.get('id') === tagId;
                            })[0].id);
                        });
                    }
                };

            isChecked ?
                tags.add({
                    id: tagId,
                    value: this.campaign.get('tags', 'raw').filter(function(cTag) {
                        return cTag.get('id') === tagId;
                    })[0].get('value')
                }) :
                tags.remove(tagId);

            this.validateTags(this.newTagsInput.val());
        }

    },
        {
            live: function() {
                BEM.blocks.checkbox.on('change', function(e) {
                    var popupContent = e.block.findBlockOutside('b-group-tags-popup-content');

                    popupContent && popupContent._onTagCheckboxChange(e.block);
                });
            }
        });

})(jQuery);
