BEM.DOM.decl({ block: 'b-group-tags', elem: 'switcher' }, {

    onSetMod: {
        js: function() {
            var params = this.params.innerBlockParams;
            this.bindTo('switcher', 'click', function() {
                // используя общий outboard-controls
                this.__self.getOutboardControls(params).
                    // тогглим его, принуждая менять модели баннеров, передавая их adgroupId
                    toggle(this.elem('switcher'), params.adgroupIds);
            });
        }
    }

}, {

    _outboard: null,

    _innerBlock: 'b-group-tags-popup-content',

    /**
     * Создаёт общий outboard-controls для всех баннеров
     * @param {Object} innerBlockParams
     * @return {BEM}
     */
    getOutboardControls: function(innerBlockParams) {
        var pageElem,
            outboardControls;

        if (this._outboard) return this._outboard;

        innerBlockParams.block = this._innerBlock;

        pageElem = BEM.blocks['b-page'].getInstance().domElem;
        outboardControls = {
            block: 'b-outboard-controls',
            js: true,
            mix: [{ block: 'b-group-tags', elem: 'dropdown' }],
            content: {
                elem: 'popup',
                autoclosable: 'yes',
                header: false,
                directions: [
                    { to: 'right', axis: 'middle', tail: 'middle', offset: { bottom: -60 } },
                    'bottom-left-center',
                    'top-left-right'
                ],
                mix: [{ block: 'b-group-tags', elem: 'popup' }],
                innerBlock: innerBlockParams
            }
        };

        return this._outboard = $(BEMHTML.apply(outboardControls)).appendTo(pageElem).bem('b-outboard-controls');
    }

});
