block('b-group-tags').addJs()(function() {
    return {
        name: 'b-group-tags',
        tagUrl: this.ctx.tagUrl,
        currentTagId: this.ctx.currentTagId,
        campaignTags: this.ctx.campaignTags,
        cid: this.data.campaign.cid,
        modelParams: this.ctx.modelParams,
        saveCampTagsOnly: this.ctx.saveCampTagsOnly
    };
});

block('b-group-tags').content()(function() {
    var data = this.data,
        group = this.ctx.group,
        switcherText = this.ctx.switcherText || iget2('b-group-tags', 'metki', 'Метки: '),
        tags = [],
        tagIds = [],
        result = [],
        campaignTags = this.ctx.campaignTags,
        saveCampTagsOnly = this.ctx.saveCampTagsOnly,
        editable = this.ctx.editable ||
        (data.allow_edit_camp && !hasLoginRights('media_control') && data.archived !== 'Yes'),
        switcher;

    // Если уже готов список тэгов (массив объектов заголовок/id)
    if (this.ctx.tagsList) {
        tags = this.ctx.tagsList;
        saveCampTagsOnly && (tagIds = tags.map(function(tag) {
            return tag.id;
        }));
    } else {
        campaignTags.forEach(function(tag) {
            if (group.tags && group.tags[tag.id]) {
                tags.push(tag);
                saveCampTagsOnly && tagIds.push(tag.id);
            }
        });
    }

    if (editable) {
        switcher = this.ctx.switcher || {
            elem: 'switcher',
            switcherText: switcherText
        };

        switcher.js || (switcher.js = true);

        (switcher.mix || (switcher.mix = []))
            .push({
                block: 'b-group-tags',
                elem: 'switcher',
                js: {
                    innerBlockParams: {
                        adgroupIds: [this.ctx.group.adgroup_id || this.ctx.group.modelId],
                        modelParams: {
                            id: this.data.campaign.cid,
                            name: u.campaign.getCampaignModelName(this.data.campaign.mediaType)
                        },
                        campaignTags: campaignTags,
                        saveCampTagsOnly: saveCampTagsOnly,
                        useBanner: this.ctx.useBanner
                    }
                }
            });

        result.push(switcher);

    } else {
        tags.length && result.push({
            elem: 'view-only-caption',
            content: switcherText
        });
    }

    result.push({
        elem: 'tags-link-list',
        content: {
            block: 'b-group-tags-list',
            tagUrl: this.ctx.tagUrl,
            currentTagId: this.ctx.currentTagId,
            tags: tags
        }
    });

    return result;
});
