BEM.DOM.decl({ block: 'b-group-tags' }, {
    onSetMod: {
        js: function() {
            BEM.blocks['i-utils'].graspSelf.call(this, {
                hidden: 'hidden',
                tagsList: 'tags-link-list'
            });
            this.counter = 0;

            var model = this.model = BEM.MODEL.getOrCreate(this.params.modelParams);

            model.on('fix', this.renderBannersTagsLinks, this);
        }
    },

    /**
     * рисует строку выбранных тегов баннера
     * при необходимости выставляет значение в скрытое поле
     */
    renderBannersTagsLinks: function() {
        var params = this.params,
            tagIds = [],
            tags = this.model
                .get('tags', 'raw')
                .map(function(tag) {
                    tagIds.push(tag.get('id'));

                    return {
                        id: tagIds[tagIds.length - 1],
                        value: tag.get('value')
                    };
                });

        BEM.DOM.update(
            this.tagsList,
            BEMHTML.apply({
                block: 'b-group-tags-list',
                tagUrl: params.tagUrl,
                currentTagId: params.currentTagId,
                tags: tags
            })
        );

        params.saveCampTagsOnly && this.hidden.val(tagIds.join(','));
    }

}, {
    live: function() {
        this.liveInitOnEvent('switcher', 'click');
    }
});
