/**
 * @param {{ groupModel: { name: <String>, id: <String> }, campaignModel: { name: <String>, id: <String> } }} this.params.modelParams параметры моделей группы и кампании
 */
BEM.DOM.decl('b-group-tags2-controller', {
    onSetMod: {
        js: function() {
            this._tagsList = this.findBlockOn('b-group-tags2');
            this._groupModel = BEM.MODEL.getOrCreate(this.params.modelParams.group);
            this._campaignModel = BEM.MODEL.getOrCreate(this.params.modelParams.campaign);
            this._popup = BEM.blocks['b-shared-popup'].getInstance({
                disposition: 'dropdown',
                'content-adaptive': 'yes',
                'has-close': 'yes'
            }, {
                directions: ['right', 'bottom', 'top']
            });

            this._tagsList.on('toggleRequested', function(e, switcher) {
                this._onEdit(switcher);
            }, this);
        }
    },

    /**
     * Колбек запроса на редактирование
     * @param {jQuery} eventTarget DOM элемент, взаимодействие с которым вызвало запрос
     */
    _onEdit: function(eventTarget) {
        var tagsEdit,
            getTagValue = function(tag) { return tag.get('value'); },
            campaignTags = (this._campaignModel.get('tags') || []).map(getTagValue);

        this._popup.setContent(BEMHTML.apply({
            block: 'b-group-tags2-edit',
            availableTags: campaignTags,
            selectedTags: (this._groupModel.get('tags') || []).map(getTagValue),
            useBanner: this._campaignModel.get('mediaType') === 'mcbanner'
        }));

        tagsEdit = this._popup.findBlockInside('b-group-tags2-edit');

        tagsEdit
            .on('tagsChanged', function(e, tagsData) {
                var validationResult = this.validateTags(tagsData.tags, {
                    campaignTags: campaignTags
                });

                tagsEdit.setError(validationResult.isValid ? '' : validationResult.error);
            }, this)
            .on('save', function(e, tagsData) {
                var validationResult = this.validateTags(tagsData.tags, {
                    campaignTags: campaignTags
                });

                if (validationResult.isValid) {
                    this._onSave(tagsData);
                }
            }, this)
            .on('cancel', function() {
                this._popup.hide();
            }, this);

        this._popup.toggle(eventTarget);
    },

    /**
     * Колбек запроса на сохранение
     * @param {{ tags: <String[]>, newTags: <String[]> }} tagsData введенные пользователем данные о тегах
     */
    _onSave: function(tagsData) {
        tagsData.newTags.forEach(function(newTag) {
            this._campaignModel.get('tags').add({ value: newTag });
        }, this);
        this._groupModel.set('tags', tagsData.tags.map(function(tag) {
            return { value: tag };
        }));
        this._tagsList.val(tagsData.tags);
        this._popup.hide();
    },

    /**
     * Валидирует теги
     * @param {String[]} tags
     * @param {{ campaignTags: <String[]> }} contextData
     * @returns {{ isValid: <Boolean>, error: <String> }}
     */
    validateTags: function(tags, contextData) {
        var maxLength = u.consts('MAX_TAG_LENGTH'),
            maxCount = u.consts('MAX_TAGS_FOR_CAMPAIGN'),
            maxCountForGroup = u.consts('MAX_TAGS_FOR_BANNER'),
            errors = [],
            errorsStr,
            group = this._groupModel,
            campaignTags = contextData.campaignTags,
            campTagsHash = campaignTags.reduce(function(res, tag) {
                res[tag] = true;

                return res;
            }, {});

        if (tags.filter(function(tag) { return !campTagsHash[tag]; }).length > maxCount - campaignTags.length)
            errors.push(iget2('b-group-tags2-controller', 'nelzya-sozdavat-bolshe-s', 'Нельзя создавать больше {foo} меток', {
                foo: maxCount
            }));

        if (tags.length > maxCountForGroup) {
            errors.push(iget2('b-group-tags2-controller', 'nelzya-ustanavlivat-na-gruppu', 'Нельзя устанавливать на группу больше {foo} меток', {
                foo: maxCountForGroup
            }));
        }

        tags.forEach(function(tag) {
            if (tag.length > maxLength) {
                errors.push(iget2('b-group-tags2-controller', 's-prevyshaet-dopustimuyu-dlinu', '{foo} превышает допустимую длину', {
                    foo: '<pre>&laquo;' + u.escapeHTML(tag) + '&raquo;</pre>'
                }));
            }
        });

        errorsStr = errors.map(function(el) { return '<div>' + el + '</div>'; }).join('') || '';

        return {
            isValid: !errorsStr.length,
            error: errorsStr
        };
    }
});
