block('b-group-tags2-edit')(
    def()(function() {
        return applyNext({
            vmData: {
                availableTags: this.ctx.availableTags,
                selectedTags: this.ctx.availableTags.reduce(function(res, tag) {
                    res[tag] = this.ctx.selectedTags.indexOf(tag) !== -1;

                    return res;
                }.bind(this), {})
            }
        });
    }),

    js()(function() {
        return {
            modelName: 'b-group-tags2-edit',
            modelData: this.vmData
        };
    }),

    mix()(function() {
        return {
            block: 'i-selectable',
            js: {
                items: this.vmData.availableTags.reduce(function(res, tag) {
                    res[tag] = {
                        isSelected: this.vmData.selectedTags[tag],
                        data: { tag: tag }
                    };

                    return res;
                }.bind(this), {})
            }
        };
    }),

    content()(function() {
        return { elem: 'form', useBanner: this.ctx.useBanner }
    }),

    elem('form').content()(function() {
        return [
            {
                elem: 'header',
                useBanner: this.ctx.useBanner
            },
            {
                elem: 'checkbox-container-wrapper',
                content: { elem: 'checkbox-container' }
            },
            {
                elem: 'new-tags'
            },
            {
                elem: 'errors'
            },
            {
                elem: 'controls'
            }
        ]
    }),

    elem('header').content()(function() {
        return this.ctx.useBanner ? iget2('b-group-tags2-edit', 'metki-bannera', 'Метки баннера') : iget2('b-group-tags2-edit', 'metki-obyavleniya', 'Метки объявления');
    }),

    elem('new-tags').content()(function() {
        return {
            block: 'input',
            placeholder: iget2('b-group-tags2-edit', 'novye-metki-cherez-zapyatuyu', 'Новые метки (через запятую)'),
            content: [
                {
                    elem: 'control'
                }
            ]
        };
    }),

    elem('checkbox').content()(function() {
        return {
            block: 'checkbox',
            mods: { checked: this.ctx.checked ? 'yes' : '' },
            mix: [
                {
                    block: 'b-selectable-control',
                    mods: { type: 'checkbox' },
                    js: { key: u.escapeHTML(this.ctx.value) }
                }
            ],
            text: this.ctx.value
        };
    }),

    elem('controls').content()(function() {
        return [
            {
                block: 'button',
                mods: { theme: 'action' },
                mix: [{
                    block: 'b-group-tags2-edit',
                    elem: 'save'
                }],
                content: iget2('b-group-tags2-edit', 'sohranit', 'Сохранить')
            },
            {
                block: 'button',
                mix: [{
                    block: 'b-group-tags2-edit',
                    elem: 'cancel'
                }],
                content: iget2('b-group-tags2-edit', 'otmena', 'Отмена')
            }
        ];
    })
);
