BEM.MODEL.decl('b-group-tags2-edit', {
    // Масив доступных для выбора тегов
    availableTags: 'array',
    // Выбранные теги, в ключах - значения тегов, в значения - состояние: выбран или нет
    selectedTags: 'object',
    // Масив тегов, которые введены в инпут
    newTags: 'array',
    // Все выбранные теги
    tags: {
        type: 'array',
        dependsFrom: ['selectedTags', 'newTags'],
        calculate: function() {
            return u._.union(this.getSelectedTags(), this.get('newTags'));
        }
    }
}, {
    /**
     * Возвращает массив тегов, выбранных чекбоксами
     * @returns {String[]}
     */
    getSelectedTags: function() {
        var selectedTagsHash = this.get('selectedTags');

        return Object.keys(selectedTagsHash).filter(function(tag) {
            return selectedTagsHash[tag];
        });
    },

    /**
     * Возвращает новые теги, то есть те, которые не было среди доступных
     * @returns {String[]}
     */
    getNewTags: function() {
        return u._.difference(this.get('newTags').slice(), this.get('availableTags').slice());
    }
});
