/**
 * @param {String[]} this.ctx.tags теги, которые нужно отобразить
 */
block('b-group-tags2')(
    def()(function() {
        return applyNext({
            vmData: { tags: this.ctx.tags }
        });
    }),

    js()(function() {
        return {
            modelParams: {
                name: 'b-group-tags2',
                data: this.vmData
            }
        };
    }),

    content()([
        {
            elem: 'switcher'
        },
        {
            elem: 'tags-list'
        },
        {
            elem: 'data'
        }
    ]),

    elem('switcher').replace()(function() {
        return {
            block: 'button',
            mix: {
                block: 'b-group-tags2',
                elem: 'switcher'
            },
            mods: { theme: 'normal' },
            content: iget2('b-group-tags2', 'zadat', 'Задать')
        };
    }),

    elem('tags-list').content()(function() {
        return {
            block: 'b-group-tags-list',
            tags: this.vmData.tags
        };
    })
);
