/**
 * @fires b-group-tags2#toggleRequested
 */
BEM.DOM.decl({ block: 'b-group-tags2', baseBlock: 'i-glue' }, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this.subscriptionManager = BEM.create('i-subscription-manager');

            this.subscriptionManager
                .wrap(this.model)
                .on('tags', 'change', function() {
                    this._renderTagsList();
                }, this);
        }
    },

    /**
     * @override {BEM.DOM}
     */
    destruct: function() {
        this.subscriptionManager.dispose();

        return this.__base.apply(this, arguments);
    },

    /**
     * Возвращает или устанавливает значение тегов
     * @param {String[]} [value] теги, которые нужно отобразить
     * @returns {this|String[]}
     */
    val: function(value) {
        if (arguments.length == 1) {
            this.model.set('tags', value);

            return this;
        } else {
            return this.model.get('tags').slice();
        }
    },

    /**
     * Рисует строку выбранных тегов баннера
     */
    _renderTagsList: function() {
        BEM.DOM.update(
            this.elem('tags-list'),
            BEMHTML.apply({
                block: 'b-group-tags-list',
                tags: this.model.get('tags').map(function(tag) {
                    return { value: tag };
                })
            })
        );
    }

}, {
    live: function() {
        this.liveInitOnBlockInsideEvent('click', 'button', function() {
            this.trigger('toggleRequested', this.elem('switcher'));
        });
    }
});
