u.register({
    groupTags2: {
        /**
         * Возвращает массив тегов по данным тегов группы и кампании в серверном формате
         * @param {Object[]} campTags массив тегов, по структуре совпадающих с m-campaign-tag
         * @param {Object} groupTags хеш с тегами, где ключи - идентификаторы тегов, а значения - 1
         * @returns {String[]}
         */
        makeTagsArray: function(campTags, groupTags) {
            return campTags.reduce(function(res, tag) {
                if (groupTags[tag.tag_id || tag.id]) {
                    res.push(tag);
                }

                return res;
            }, []);
        }
    }
});
