block('b-group-url-params')(

    def()(function() {
        return applyNext({
            'mods.expand': this.ctx.group.href_params ? 'yes' : this.mods.expand
        });
    }),

    js()(function() {
        return {
            modelParams: {
                name: 'b-group-url-params',
                id: this.ctx.group.modelId
            },
            modelData: {
                lengthLimit: u.consts('MAX_URL_LENGTH'),
                parentModelParams: this.ctx.parentModelParams
            }
        };
    }),

    content()(function() {
        return [
            {
                elem: 'controls',
                content: [
                    {
                        elem: 'url-params-switcher',
                        content: {
                            block: 'button',
                            mods: {
                                pseudo: 'yes',
                                add: 'left'
                            },
                            content: iget2('b-group-url-params', 'dobavit-parametry-k-ssylkam', 'Добавить параметры к ссылкам')
                        }
                    },
                    {
                        elem: 'url-params-input',
                        content: {
                            block: 'input',
                            value: this.ctx.group.href_params,
                            mix: {
                                block: 'b-group-url-params',
                                elem: 'model-field',
                                js: {
                                    name: 'params',
                                    type: 'input'
                                }
                            },
                            placeholder: iget2('b-group-url-params', 'parametry-v-url-neobyazatelno', 'Параметры в URL (необязательно)'),
                            content: [
                                {
                                    elem: 'control'
                                }
                            ]
                        }
                    },
                    {
                        elem: 'url-params-help-link',
                        content: {
                            block: 'b-help-link',
                            mix: {
                                block: 'b-group-url-params',
                                elem: 'help-link'
                            },
                            mods: {
                                type: 'modal'
                            },
                            stretched: true,
                            url: u.getHelpUrl('dynamic-text-ads-url-tags')
                        }
                    },
                    {
                        elem: 'url-params-addon',
                        content: {
                            block: 'button',
                            mods: {
                                pseudo: 'yes'
                            },
                            content: iget2('b-group-url-params', 'otmenit', 'Отменить')
                        }
                    }
                ]
            },
            {
                elem: 'message'
            }
        ];
    })
);
