BEM.DOM.decl({ block: 'b-group-url-params', baseBlock: 'i-glue' }, {
    onSetMod: {
        js: function() {
            this.__base();
            this.model.init();

            u.graspSelf.call(this, {
                _switcher: 'button inside url-params-switcher',
                _cancel: 'button inside url-params-addon',
                _message: 'message'
            });

            this._initEvents();
        }
    },

    /**
     * Выполняет подписку на события через i-subscription-manager
     * @private
     */
    _initEvents: function() {
        this._listener = BEM.create('i-subscription-manager');

        this._listener.wrap(this._cancel)
            .on('click', function() {
                var params = this.model.get('params');

                this.model.update({ tmpParams: params, params: '' });
                this.delMod('expand');
            }, this);

        this._listener.wrap(this._switcher)
            .on('click', function() {
                var params = this.model.get('params'),
                    tmpParams = this.model.get('tmpParams');

                this.model.update({ params: params || tmpParams });
                this.setMod('expand', 'yes');
            }, this);

        this._listener.wrap(this.model)
            .on('params', 'change', $.debounce(function() {
                this.model.validate('params');
                this._updateWarnings();
                this.model.syncToDM();
            }, 500, this), this)
            .on('validated', function(e, data) {
                var errText = data.valid ?
                    '' :
                    data.errors.map(function(err) {
                        return err.text;
                    }).join(', ');

                this._updateWarnings(errText);
            }, this);
    },

    _updateWarnings: function(errText) {
        this._message.text(errText);
    },

    /**
     * Удаляет блок и подписки i-subscription-manager
     * @override
     */
    destruct: function() {
        this._listener.dispose();
        this.__base();
    }
});
