BEM.MODEL.decl({ name: 'b-group-url-params', baseModel: 'vm-sync-dm' }, {
    /**
     * Параметры в URL
     */
    params: {
        type: 'string',
        validation: {
            rules: {
                maxLength: {
                    value: 1024,
                    text: u.pluralForms(iget2(
                        'b-group-url-params',
                        'prevyshena-maksimalnaya-dlina-stroki',
                        'Превышена максимальная длина строки параметров URL, {foo} {символ|символа|символов}.',
                        {
                            foo: 1024
                        }
                    ), 1024),
                    needToValidate: function(val) {
                        return !!val;
                    }
                }
            }
        }
    },

    /**
     * Значение поля params в скрытом состоянии (не синхронизируется с dm)
     */
    tmpParams: {
        type: 'string'
    },

    /**
     * Хэш с параметрами родительской модели
     */
    parentModelParams: {
        type: 'object',
        internal: true
    },

    /**
     * декларация DM модели
     */
    _dmDecl: {
        type: 'object',
        calculate: function() {
            return this.get('parentModelParams')
        }
    }
}, {
    init: function() {
        this.__base.apply(this, arguments);

        this.fix();

        this.getDM().on('href_params', 'change', this.syncFromDM, this);
    },

    /**
     * Готовит данные для синхронизации в DM
     */
    prepareDataToDM: function(data) {
        return { href_params: data.params };
    },

    /**
     * Готовит данные для синхронизации из DM
     */
    prepareDataFromDM: function(data) {
        return { params: data.href_params };
    },

    /**
     * Переопределяем, в DM нужны даже невалидные данные
     */
    syncToDM: function() {
        this._setToDM();
    }
});
